/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.systemgraph;

import java.util.Optional;
import org.neo4j.dbms.database.DatabaseContext;
import org.neo4j.dbms.database.DatabaseContextProvider;
import org.neo4j.dbms.systemgraph.SystemDatabaseProvider;
import org.neo4j.function.Suppliers;
import org.neo4j.graphdb.event.DatabaseEventContext;
import org.neo4j.graphdb.event.DatabaseEventListener;
import org.neo4j.graphdb.event.DatabaseEventListenerAdapter;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.kernel.monitoring.DatabaseEventListeners;

public class ContextBasedSystemDatabaseProvider
extends DatabaseEventListenerAdapter
implements SystemDatabaseProvider {
    private final DatabaseContextProvider<? extends DatabaseContext> databaseContextProvider;
    private volatile Suppliers.Lazy<DatabaseContext> contextCache;
    private volatile Suppliers.Lazy<GraphDatabaseAPI> databaseCache;

    public ContextBasedSystemDatabaseProvider(DatabaseContextProvider<? extends DatabaseContext> databaseContextProvider, DatabaseEventListeners databaseEventListeners) {
        this.databaseContextProvider = databaseContextProvider;
        this.resetCache();
        databaseEventListeners.registerDatabaseEventListener((DatabaseEventListener)this);
    }

    @Override
    public GraphDatabaseAPI database() throws SystemDatabaseProvider.SystemDatabaseUnavailableException {
        return (GraphDatabaseAPI)this.databaseCache.get();
    }

    @Override
    public <T> Optional<T> dependency(Class<T> type) throws SystemDatabaseProvider.SystemDatabaseUnavailableException {
        return SystemDatabaseProvider.dependency(((DatabaseContext)this.contextCache.get()).dependencies(), type);
    }

    public void databaseCreate(DatabaseEventContext eventContext) {
        if (eventContext.getDatabaseName().equals("system")) {
            this.resetCache();
        }
    }

    private void resetCache() {
        this.contextCache = Suppliers.lazySingleton(this::databaseContext);
        this.databaseCache = Suppliers.lazySingleton(() -> ((DatabaseContext)this.contextCache.get()).databaseFacade());
    }

    private DatabaseContext databaseContext() {
        return (DatabaseContext)this.databaseContextProvider.getDatabaseContext(NamedDatabaseId.NAMED_SYSTEM_DATABASE_ID).orElseThrow(SystemDatabaseProvider.SystemDatabaseUnavailableException::new);
    }
}

