/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.database;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.connectors.BoltConnector;
import org.neo4j.configuration.connectors.HttpConnector;
import org.neo4j.configuration.connectors.HttpsConnector;
import org.neo4j.configuration.helpers.SocketAddress;
import org.neo4j.dbms.DatabaseStateService;
import org.neo4j.dbms.database.DatabaseDetails;
import org.neo4j.dbms.database.DatabaseDetailsExtras;
import org.neo4j.dbms.database.DefaultDatabaseDetailsExtrasProvider;
import org.neo4j.dbms.database.ServerDetails;
import org.neo4j.dbms.database.TopologyInfoService;
import org.neo4j.dbms.database.readonly.ReadOnlyDatabases;
import org.neo4j.dbms.identity.ServerId;
import org.neo4j.dbms.systemgraph.InstanceModeConstraint;
import org.neo4j.dbms.systemgraph.TopologyGraphDbmsModel;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.internal.Version;

public class DefaultTopologyInfoService
implements TopologyInfoService {
    private final ReadOnlyDatabases readOnlyDatabases;
    private final ServerId serverId;
    private final Config config;
    private final DatabaseStateService stateService;
    private final DefaultDatabaseDetailsExtrasProvider databaseDetailsExtrasProvider;
    private final SocketAddress fixBoltAddress;

    public DefaultTopologyInfoService(ServerId serverId, Config config, DatabaseStateService stateService, ReadOnlyDatabases readOnlyDatabases, DefaultDatabaseDetailsExtrasProvider databaseDetailsExtrasProvider) {
        this.serverId = serverId;
        this.config = config;
        this.stateService = stateService;
        this.readOnlyDatabases = readOnlyDatabases;
        this.databaseDetailsExtrasProvider = databaseDetailsExtrasProvider;
        this.fixBoltAddress = (SocketAddress)config.get(BoltConnector.advertised_address);
    }

    @Override
    public Set<ServerDetails> servers(Transaction transaction) {
        Set<String> desiredDatabases = Set.of("system", (String)this.config.get(GraphDatabaseSettings.initial_default_database));
        Set<String> hostedDatabases = this.stateService.stateOfAllDatabases().keySet().stream().map(NamedDatabaseId::name).collect(Collectors.toSet());
        return Set.of(new ServerDetails(this.serverId, this.serverId.uuid().toString(), this.address((Setting<Boolean>)BoltConnector.enabled, (Setting<SocketAddress>)BoltConnector.advertised_address), this.address((Setting<Boolean>)HttpConnector.enabled, (Setting<SocketAddress>)HttpConnector.advertised_address), this.address((Setting<Boolean>)HttpsConnector.enabled, (Setting<SocketAddress>)HttpsConnector.advertised_address), Set.of(), ServerDetails.State.ENABLED, ServerDetails.RunningState.AVAILABLE, hostedDatabases, desiredDatabases, Set.of(), Set.of(), InstanceModeConstraint.NONE, Optional.of(Version.getNeo4jVersion())));
    }

    @Override
    public List<DatabaseDetails> databases(Transaction transaction, List<NamedDatabaseId> databaseIds, TopologyInfoService.RequestedExtras requestedExtras) {
        return databaseIds.stream().map(id -> this.database((NamedDatabaseId)id, requestedExtras)).collect(Collectors.toList());
    }

    private DatabaseDetails database(NamedDatabaseId id, TopologyInfoService.RequestedExtras detailsLevel) {
        DatabaseDetailsExtras extraDetails = this.databaseDetailsExtrasProvider.extraDetails(id.databaseId(), new TopologyInfoService.RequestedExtras(false, detailsLevel.storeInfo()));
        return new DatabaseDetails(Optional.of(this.serverId), this.readOnlyDatabases.isReadOnly(id.databaseId()) ? TopologyGraphDbmsModel.DatabaseAccess.READ_ONLY : TopologyGraphDbmsModel.DatabaseAccess.READ_WRITE, Optional.of(this.fixBoltAddress), Optional.of("primary"), true, this.stateService.stateOfDatabase(id).operatorState().description(), this.stateService.causeOfFailure(id).map(Throwable::getMessage).orElse(""), Optional.empty(), Optional.of(0L), id, id.isSystemDatabase() ? "system" : "standard", Collections.emptyMap(), extraDetails.storeId(), extraDetails.externalStoreId(), 1, 0);
    }

    private Optional<SocketAddress> address(Setting<Boolean> enabled, Setting<SocketAddress> advertisedAddress) {
        return Optional.ofNullable((Boolean)this.config.get(enabled) != false ? (SocketAddress)this.config.get(advertisedAddress) : null);
    }
}

