/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.systemgraph.allocation;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.neo4j.dbms.systemgraph.TopologyGraphDbmsModel;
import org.neo4j.dbms.systemgraph.allocation.DatabaseWeight;
import org.neo4j.exceptions.InvalidArgumentException;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.util.VisibleForTesting;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.IntegralValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.MapValueBuilder;

public record DatabaseAllocationHints(Set<Hint<?>> hints) {
    public static final DatabaseAllocationHints EMPTY = new DatabaseAllocationHints(Set.of());
    public static final DatabaseAllocationHints DEFAULT = new DatabaseAllocationHints(Arrays.stream(Hint.class.getPermittedSubclasses()).filter(hint -> DatabaseAllocationHints.defaultValue(hint).isPresent()).map(hintClass -> DatabaseAllocationHints.defaultValue(hintClass).orElseThrow()).collect(Collectors.toSet()));
    public static final Set<String> VALID_HINT_KEYS = Arrays.stream(Hint.class.getPermittedSubclasses()).map(DatabaseAllocationHints::key).collect(Collectors.toSet());

    public static DatabaseAllocationHints createFromInput(MapValue providedHints) {
        HashSet hints = new HashSet();
        providedHints.foreach((k, v) -> hints.add(DatabaseAllocationHints.createFromInput(k, v)));
        if (hints.isEmpty()) {
            return EMPTY;
        }
        return new DatabaseAllocationHints(Set.copyOf(hints));
    }

    public static DatabaseAllocationHints createFromAllocationHintsNode(Node allocationHintsNode) {
        DatabaseAllocationHints.assertLabel(allocationHintsNode, TopologyGraphDbmsModel.ALLOCATION_HINTS_LABEL);
        return DatabaseAllocationHints.createFromNode(allocationHintsNode, "").orElse(EMPTY);
    }

    public static DatabaseAllocationHints createFromSettingsNode(Node settingsNode) {
        DatabaseAllocationHints.assertLabel(settingsNode, TopologyGraphDbmsModel.TOPOLOGY_GRAPH_CONFIG_LABEL);
        return DatabaseAllocationHints.createFromNode(settingsNode, "default_allocation_hint_").orElse(DEFAULT);
    }

    private static Optional<DatabaseAllocationHints> createFromNode(Node node, String prefix) {
        Set<Hint<?>> hints = node.getAllProperties().entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith(prefix)).map(entry -> Map.entry(((String)entry.getKey()).substring(prefix.length()), entry.getValue())).filter(entry -> VALID_HINT_KEYS.contains(entry.getKey())).map(entry -> DatabaseAllocationHints.createFromNodeProperty((String)entry.getKey(), entry.getValue())).collect(Collectors.toUnmodifiableSet());
        if (hints.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new DatabaseAllocationHints(hints));
    }

    public static void validate(String key, AnyValue value) {
        DatabaseAllocationHints.createFromInput(key, value);
    }

    @VisibleForTesting
    static Hint<?> createFromInput(String key, AnyValue value) {
        switch (key) {
            case "weight": {
                if (value instanceof IntegralValue) {
                    IntegralValue v = (IntegralValue)value;
                    return new DatabaseWeight((int)v.longValue());
                }
                throw InvalidArgumentException.incorrectTypeForAllocationHint((String)value.prettify(), (String)"weight", (String)value.getTypeName());
            }
        }
        throw InvalidArgumentException.invalidAllocationHintKey((String)key, VALID_HINT_KEYS);
    }

    private static Hint<?> createFromNodeProperty(String key, Object value) {
        switch (key) {
            case "weight": {
                if (value instanceof Integer) {
                    Integer v = (Integer)value;
                    return new DatabaseWeight(v);
                }
                throw InvalidArgumentException.incorrectTypeForAllocationHint((String)String.valueOf(value), (String)"weight", (String)value.getClass().getSimpleName());
            }
        }
        throw InvalidArgumentException.invalidAllocationHintKey((String)key, VALID_HINT_KEYS);
    }

    @VisibleForTesting
    static String key(Class<?> hintClass) {
        DatabaseAllocationHints.assertClass(hintClass);
        if (hintClass == DatabaseWeight.class) {
            return "weight";
        }
        throw new IllegalArgumentException("Unexpected hint type with unknown key: " + hintClass.getSimpleName());
    }

    @VisibleForTesting
    static Optional<Hint<?>> defaultValue(Class<?> hintClass) {
        DatabaseAllocationHints.assertClass(hintClass);
        if (hintClass == DatabaseWeight.class) {
            return Optional.of(DatabaseWeight.DEFAULT_WEIGHT);
        }
        throw new IllegalArgumentException("Unexpected hint type with unknown key: " + hintClass.getSimpleName());
    }

    private static void assertClass(Class<?> hintClass) {
        if (!Hint.class.isAssignableFrom(hintClass)) {
            throw new IllegalArgumentException(String.format("Class does not implement %s: %s", Hint.class.getSimpleName(), hintClass.getSimpleName()));
        }
    }

    private static void assertLabel(Node node, Label label) {
        Set labels = Iterables.asSet((Iterable)node.getLabels());
        String labelString = labels.stream().map(Label::name).collect(Collectors.joining(", ", "'", "'"));
        if (!labels.contains(label)) {
            throw new IllegalArgumentException(String.format("Incorrect Node labels for creating a DatabaseAllocationHints object! Required label %s, found %s", label.name(), labelString));
        }
    }

    public <U, T extends Hint<U>> Optional<U> hintValue(Class<T> clazz) {
        return this.hints.stream().filter(hint -> hint.getClass().equals(clazz)).map(clazz::cast).map(Hint::getValue).findFirst();
    }

    public DatabaseAllocationHints multiply(int multiplier) {
        return new DatabaseAllocationHints(this.hints.stream().map(hint -> {
            Hint hint2;
            if (hint instanceof DatabaseWeight) {
                DatabaseWeight weight = (DatabaseWeight)hint;
                hint2 = weight.multiply(multiplier);
            } else {
                hint2 = hint;
            }
            return hint2;
        }).collect(Collectors.toSet()));
    }

    public MapValue toMapValue() {
        if (this.hints.isEmpty()) {
            return MapValue.EMPTY;
        }
        MapValueBuilder hintsMapBuilder = new MapValueBuilder(this.hints.size());
        this.hints.forEach(h -> hintsMapBuilder.add(h.getKey(), (AnyValue)Values.of(h.getValue())));
        return hintsMapBuilder.build();
    }

    public void writeToAllocationHintsNode(Node allocationHintsNode) {
        DatabaseAllocationHints.assertLabel(allocationHintsNode, TopologyGraphDbmsModel.ALLOCATION_HINTS_LABEL);
        this.writeToNode(allocationHintsNode, "");
    }

    public void writeToSettingsNode(Node settingsNode) {
        DatabaseAllocationHints.assertLabel(settingsNode, TopologyGraphDbmsModel.TOPOLOGY_GRAPH_CONFIG_LABEL);
        this.writeToNode(settingsNode, "default_allocation_hint_");
    }

    private void writeToNode(Node node, String prefix) {
        this.hints.forEach(hint -> {
            String key = prefix + hint.getKey();
            if (!node.hasProperty(key)) {
                node.setProperty(key, hint.getValue());
            }
        });
    }

    public static sealed interface Hint<T>
    permits DatabaseWeight {
        public String getKey();

        public T getValue();
    }
}

