/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.systemgraph;

import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.neo4j.cypher.internal.CypherVersion;
import org.neo4j.dbms.systemgraph.DefaultQueryLanguageLookup;
import org.neo4j.dbms.systemgraph.SystemDatabaseProvider;
import org.neo4j.dbms.systemgraph.TopologyGraphDbmsModel;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.graphdb.event.TransactionData;
import org.neo4j.graphdb.event.TransactionEventListener;
import org.neo4j.kernel.database.DatabaseIdFactory;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.logging.InternalLog;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.memory.MemoryLimitExceededException;
import org.neo4j.scheduler.Group;
import org.neo4j.scheduler.JobScheduler;

public class CommunityDefaultQueryLanguageLookup
implements DefaultQueryLanguageLookup {
    private static String DATABASE_DEFAULT_LANGUAGE_PROPERTY = "defaultLanguage";
    private final SystemDatabaseProvider systemDb;
    private final JobScheduler scheduler;
    private final Lifecycle life = new Life();
    private final TransactionEventListener<Void> txListener = new TxListener();
    private final InternalLog log;
    private volatile boolean running = false;
    private volatile Map<NamedDatabaseId, CypherVersion> defaultQueryLanguageSnapshot = Map.of();

    public CommunityDefaultQueryLanguageLookup(SystemDatabaseProvider systemDatabaseProvider, JobScheduler jobScheduler, InternalLogProvider logProvider) {
        this.systemDb = systemDatabaseProvider;
        this.scheduler = jobScheduler;
        this.log = logProvider.getLog(this.getClass());
    }

    @Override
    public Optional<CypherVersion> defaultLanguage(NamedDatabaseId dbId) {
        return dbId != null ? Optional.ofNullable(this.defaultQueryLanguageSnapshot.get(dbId)) : Optional.empty();
    }

    public Lifecycle life() {
        return this.life;
    }

    public TransactionEventListener<Void> transactionListener() {
        return this.txListener;
    }

    private void tryUpdate() {
        int failureCount = 0;
        while (this.running) {
            try {
                Map snapshot;
                this.defaultQueryLanguageSnapshot = snapshot = this.systemDb.query(tx -> tx.findNodes(TopologyGraphDbmsModel.DATABASE_LABEL).stream().flatMap(n -> CommunityDefaultQueryLanguageLookup.makeCypherVersion(n).stream().map(v -> Map.entry(CommunityDefaultQueryLanguageLookup.makeDatabaseId(n), v))).collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, Map.Entry::getValue)));
                this.log.debug("Default query language snapshot update");
                return;
            }
            catch (SystemDatabaseProvider.SystemDatabasePanickedException e) {
                this.running = false;
                this.log.warn("Default query language update failed because of system db panic", (Throwable)e);
                return;
            }
            catch (SystemDatabaseProvider.SystemDatabaseUnavailableException | TransactionFailureException | MemoryLimitExceededException e) {
                if (failureCount++ % 10 == 0) {
                    this.log.debug("Default query language update failed (attempt %s)".formatted(failureCount), e);
                }
                if (failureCount >= 100) {
                    this.log.error("Aborting default query language update after %s attempts".formatted(failureCount), e);
                    return;
                }
                CommunityDefaultQueryLanguageLookup.sleep(100);
            }
            catch (Exception e) {
                this.log.error("Failed to read default query language", (Throwable)e);
                return;
            }
        }
    }

    private static NamedDatabaseId makeDatabaseId(Node databaseNode) {
        String name = (String)databaseNode.getProperty("name");
        UUID uuid = UUID.fromString((String)databaseNode.getProperty("uuid"));
        return DatabaseIdFactory.from((String)name, (UUID)uuid);
    }

    private static Optional<CypherVersion> makeCypherVersion(Node databaseNode) {
        return CypherVersion.fromStoredValueOptional((Object)databaseNode.getProperty(DATABASE_DEFAULT_LANGUAGE_PROPERTY, null));
    }

    private static void sleep(int time) {
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    private class Life
    implements Lifecycle {
        private Life() {
        }

        public void init() {
        }

        public void start() throws Exception {
            CommunityDefaultQueryLanguageLookup.this.scheduler.schedule(Group.TOPOLOGY_GRAPH_DBMS_MODEL, () -> {
                CommunityDefaultQueryLanguageLookup.this.running = true;
                CommunityDefaultQueryLanguageLookup.this.tryUpdate();
            }).get();
        }

        public void stop() {
            CommunityDefaultQueryLanguageLookup.this.running = false;
        }

        public void shutdown() {
        }
    }

    private class TxListener
    implements TransactionEventListener<Void> {
        private TxListener() {
        }

        public Void beforeCommit(TransactionData data, Transaction transaction, GraphDatabaseService databaseService) throws Exception {
            return null;
        }

        public void afterCommit(TransactionData data, Void state, GraphDatabaseService databaseService) {
            if (CommunityDefaultQueryLanguageLookup.this.running) {
                CommunityDefaultQueryLanguageLookup.this.scheduler.schedule(Group.TOPOLOGY_GRAPH_DBMS_MODEL, CommunityDefaultQueryLanguageLookup.this::tryUpdate);
            }
        }

        public void afterRollback(TransactionData data, Void state, GraphDatabaseService databaseService) {
        }
    }
}

