/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.routing;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.connectors.BoltConnector;
import org.neo4j.configuration.connectors.ConnectorPortRegister;
import org.neo4j.configuration.connectors.ConnectorType;
import org.neo4j.configuration.helpers.SocketAddress;
import org.neo4j.dbms.routing.ClientSideRoutingTableProvider;
import org.neo4j.dbms.routing.RoutingException;
import org.neo4j.dbms.routing.RoutingOption;
import org.neo4j.dbms.routing.RoutingResult;
import org.neo4j.dbms.routing.RoutingTableServiceHelpers;
import org.neo4j.dbms.routing.RoutingTableTTLProvider;
import org.neo4j.dbms.routing.ServerSideRoutingTableProvider;
import org.neo4j.internal.helpers.HostnamePort;
import org.neo4j.kernel.database.DatabaseReferenceImpl;
import org.neo4j.logging.InternalLog;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.values.virtual.MapValue;

public class SingleAddressRoutingTableProvider
implements ClientSideRoutingTableProvider,
ServerSideRoutingTableProvider {
    private final ConnectorPortRegister portRegister;
    private final RoutingOption routingOption;
    private final RoutingTableTTLProvider routingTableTTLProvider;
    private final Config config;
    private final InternalLog log;

    public SingleAddressRoutingTableProvider(ConnectorPortRegister portRegister, RoutingOption routingOption, Config config, InternalLogProvider logProvider, RoutingTableTTLProvider ttlProvider) {
        this.portRegister = portRegister;
        this.routingOption = routingOption;
        this.routingTableTTLProvider = ttlProvider;
        this.config = config;
        this.log = logProvider.getLog(this.getClass());
    }

    @Override
    public RoutingResult getRoutingResultForClientSideRouting(DatabaseReferenceImpl.Internal databaseReference, MapValue routingContext) throws RoutingException {
        return SingleAddressRoutingTableProvider.createSingleAddressRoutingResult(this.findBoltAddressToUse(routingContext), this.routingTableTTLProvider.nextTTL().toMillis(), this.routingOption);
    }

    private static RoutingResult createSingleAddressRoutingResult(SocketAddress address, long routingTableTtl, RoutingOption option) {
        List<SocketAddress> addresses = List.of(address);
        List<Object> routeEndpoints = option.route ? addresses : Collections.emptyList();
        List<Object> writeEndpoints = option.write ? addresses : Collections.emptyList();
        List<Object> readEndpoints = option.read ? addresses : Collections.emptyList();
        return new RoutingResult(routeEndpoints, writeEndpoints, readEndpoints, routingTableTtl);
    }

    private SocketAddress findBoltAddressToUse(MapValue routingContext) throws RoutingException {
        Optional<SocketAddress> addressToUse = RoutingTableServiceHelpers.findClientProvidedAddress(routingContext, 7687, this.log);
        return this.ensureBoltAddressIsUsable(addressToUse);
    }

    private SocketAddress ensureBoltAddressIsUsable(Optional<SocketAddress> address) {
        HostnamePort localAddress;
        SocketAddress addressToUse = address.filter(c -> c.getPort() > 0).orElse((SocketAddress)this.config.get(BoltConnector.advertised_address));
        if (addressToUse.getPort() <= 0 && (localAddress = this.portRegister.getLocalAddress(ConnectorType.BOLT)) != null) {
            addressToUse = new SocketAddress(addressToUse.getHostname(), localAddress.getPort());
        }
        return addressToUse;
    }

    @Override
    public RoutingResult getServerSideRoutingTable(MapValue routingContext) throws RoutingException {
        SocketAddress address = this.findBoltAddressToUse(routingContext);
        return SingleAddressRoutingTableProvider.createSingleAddressRoutingResult(address, this.routingTableTTLProvider.nextTTL().toMillis(), this.routingOption);
    }
}

