/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.systemgraph.allocation;

import org.neo4j.dbms.systemgraph.allocation.DatabaseAllocationHints;

public record DatabaseWeight(int weight) implements DatabaseAllocationHints.Hint<Integer>,
Comparable<DatabaseWeight>
{
    public static final DatabaseWeight DEFAULT_WEIGHT = new DatabaseWeight(10);
    public static final String KEY = "weight";

    public DatabaseWeight {
        if (weight < 0) {
            throw new IllegalArgumentException("A database's weight must be a positive integer");
        }
    }

    public DatabaseWeight multiply(int multiplier) {
        if (multiplier < 0) {
            throw new IllegalArgumentException("A database's weight must be a positive integer");
        }
        return new DatabaseWeight(this.weight * multiplier);
    }

    @Override
    public Integer getValue() {
        return this.weight;
    }

    @Override
    public String getKey() {
        return KEY;
    }

    @Override
    public int compareTo(DatabaseWeight other) {
        return Integer.compare(this.weight, other.weight);
    }
}

