/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.systemgraph;

import java.time.ZonedDateTime;
import java.util.Objects;
import java.util.Optional;
import org.neo4j.graphdb.Node;
import org.neo4j.util.Preconditions;
import org.neo4j.util.VisibleForTesting;

public class SeedRestoreUntil {
    Optional<Long> txId;
    Optional<ZonedDateTime> dateTime;

    private SeedRestoreUntil(Optional<Long> txId, Optional<ZonedDateTime> dateTime) {
        SeedRestoreUntil.validateArgs(txId, dateTime);
        this.txId = txId;
        this.dateTime = dateTime;
    }

    public static SeedRestoreUntil txId(long txId) {
        return new SeedRestoreUntil(Optional.of(txId), Optional.empty());
    }

    public static SeedRestoreUntil datetime(ZonedDateTime dateTime) {
        return new SeedRestoreUntil(Optional.empty(), Optional.of(dateTime));
    }

    public void writeProperty(Node database) {
        this.txId.ifPresentOrElse(txId -> database.setProperty("seedRestoreUntil", txId), () -> this.dateTime.ifPresentOrElse(dateTime -> database.setProperty("seedRestoreUntil", dateTime), () -> {
            throw new IllegalStateException("Must contain either a transaction id or transaction date");
        }));
    }

    public static SeedRestoreUntil fromObj(Object obj) {
        if (obj instanceof Number) {
            Number number = (Number)obj;
            return SeedRestoreUntil.txId(number.longValue());
        }
        if (obj instanceof ZonedDateTime) {
            ZonedDateTime zonedDateTime = (ZonedDateTime)obj;
            return SeedRestoreUntil.datetime(zonedDateTime);
        }
        throw new IllegalArgumentException("Provided value can't be converted to transaction id or transaction date");
    }

    public Optional<Long> txId() {
        return this.txId;
    }

    public Optional<ZonedDateTime> dateTime() {
        return this.dateTime;
    }

    public String toOptionValue() {
        return this.txId().map(Object::toString).orElseGet(() -> this.dateTime().map(Objects::toString).orElseThrow(() -> new IllegalStateException("Must contain either a transaction id or transaction date")));
    }

    @VisibleForTesting
    static void validateArgs(Optional<Long> txId, Optional<ZonedDateTime> dateTime) {
        if (txId.isPresent() && dateTime.isPresent()) {
            throw new IllegalArgumentException("Only one of transaction id or transaction date can be provided");
        }
        if (txId.isEmpty() && dateTime.isEmpty()) {
            throw new IllegalArgumentException("Must contain either a transaction id or transaction date");
        }
        txId.ifPresent(id -> Preconditions.checkArgument((id > 0L ? 1 : 0) != 0, (String)("Transaction id should be a positive number. Provided value: " + id)));
    }

    public String toString() {
        return this.toOptionValue();
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SeedRestoreUntil that = (SeedRestoreUntil)o;
        return Objects.equals(this.txId, that.txId) && Objects.equals(this.dateTime, that.dateTime);
    }

    public int hashCode() {
        return Objects.hash(this.txId, this.dateTime);
    }
}

