/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.commandline.dbms;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import org.neo4j.commandline.Util;
import org.neo4j.commandline.admin.AdminCommand;
import org.neo4j.commandline.admin.CommandFailed;
import org.neo4j.commandline.admin.IncorrectUsage;
import org.neo4j.commandline.admin.OutsideWorld;
import org.neo4j.commandline.arguments.Arguments;
import org.neo4j.commandline.dbms.CannotWriteException;
import org.neo4j.commandline.dbms.StoreLockChecker;
import org.neo4j.dbms.DatabaseManagementSystemSettings;
import org.neo4j.dbms.archive.Dumper;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.StoreLockException;
import org.neo4j.kernel.impl.util.Validators;
import org.neo4j.server.configuration.ConfigLoader;

public class DumpCommand
implements AdminCommand {
    private static final Arguments arguments = new Arguments().withDatabase().withTo("Destination (file or folder) of database dump.");
    private final StoreLockChecker storeLockChecker;
    private final Path homeDir;
    private final Path configDir;
    private final Dumper dumper;

    public DumpCommand(Path homeDir, Path configDir, Dumper dumper) {
        this.homeDir = homeDir;
        this.configDir = configDir;
        this.dumper = dumper;
        this.storeLockChecker = new StoreLockChecker();
    }

    public void execute(String[] args) throws IncorrectUsage, CommandFailed {
        String database = arguments.parse("database", args);
        Path archive = this.calculateArchive(database, arguments.parseMandatoryPath("to", args));
        Path databaseDirectory = Util.canonicalPath((Path)this.toDatabaseDirectory(database));
        try {
            Validators.CONTAINS_EXISTING_DATABASE.validate((Object)databaseDirectory.toFile());
        }
        catch (IllegalArgumentException e) {
            throw new CommandFailed("database does not exist: " + database, (Exception)e);
        }
        try (Closeable ignored = this.storeLockChecker.withLock(databaseDirectory);){
            this.dump(database, databaseDirectory, archive);
        }
        catch (StoreLockException e) {
            throw new CommandFailed("the database is in use -- stop Neo4j and try again", (Exception)((Object)e));
        }
        catch (IOException e) {
            this.wrapIOException(e);
        }
        catch (CannotWriteException e) {
            throw new CommandFailed("you do not have permission to dump the database -- is Neo4j running as a different user?", (Exception)e);
        }
    }

    private Path toDatabaseDirectory(String databaseName) {
        return ((File)new ConfigLoader(Arrays.asList(DatabaseManagementSystemSettings.class, GraphDatabaseSettings.class)).loadOfflineConfig(Optional.of(this.homeDir.toFile()), Optional.of(this.configDir.resolve("neo4j.conf").toFile())).with(MapUtil.stringMap((String[])new String[]{DatabaseManagementSystemSettings.active_database.name(), databaseName}), new Class[0]).get(DatabaseManagementSystemSettings.database_path)).toPath();
    }

    private Path calculateArchive(String database, Path to) {
        return Files.isDirectory(to, new LinkOption[0]) ? to.resolve(database + ".dump") : to;
    }

    private void dump(String database, Path databaseDirectory, Path archive) throws CommandFailed {
        try {
            this.dumper.dump(databaseDirectory, archive, this::isStoreLock);
        }
        catch (FileAlreadyExistsException e) {
            throw new CommandFailed("archive already exists: " + e.getMessage(), (Exception)e);
        }
        catch (NoSuchFileException e) {
            if (Paths.get(e.getMessage(), new String[0]).toAbsolutePath().equals(databaseDirectory.toAbsolutePath())) {
                throw new CommandFailed("database does not exist: " + database, (Exception)e);
            }
            this.wrapIOException(e);
        }
        catch (IOException e) {
            this.wrapIOException(e);
        }
    }

    private boolean isStoreLock(Path path) {
        return Objects.equals(path.getFileName().toString(), "store_lock");
    }

    private void wrapIOException(IOException e) throws CommandFailed {
        throw new CommandFailed(String.format("unable to dump database: %s: %s", e.getClass().getSimpleName(), e.getMessage()), (Exception)e);
    }

    public static class Provider
    extends AdminCommand.Provider {
        public Provider() {
            super("dump", new String[0]);
        }

        public Arguments allArguments() {
            return arguments;
        }

        public String description() {
            return "Dump a database into a single-file archive. The archive can be used by the load command. <destination-path> can be a file or directory (in which case a file called <database>.dump will be created). It is not possible to dump a database that is mounted in a running Neo4j server.";
        }

        public String summary() {
            return "Dump a database into a single-file archive.";
        }

        public AdminCommand create(Path homeDir, Path configDir, OutsideWorld outsideWorld) {
            return new DumpCommand(homeDir, configDir, new Dumper());
        }
    }
}

