/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.commandline.dbms;

import java.io.File;
import java.io.IOException;
import org.neo4j.commandline.admin.IncorrectUsage;
import org.neo4j.commandline.admin.OutsideWorld;
import org.neo4j.commandline.dbms.Importer;
import org.neo4j.dbms.DatabaseManagementSystemSettings;
import org.neo4j.helpers.Args;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.util.Converters;
import org.neo4j.kernel.impl.util.Validator;
import org.neo4j.kernel.impl.util.Validators;

class DatabaseImporter
implements Importer {
    private final File from;
    private final Config config;

    DatabaseImporter(Args args, Config config, OutsideWorld outsideWorld) throws IncorrectUsage {
        this.config = config;
        try {
            this.from = (File)args.interpretOption("from", Converters.mandatory(), Converters.toFile(), new Validator[]{Validators.CONTAINS_EXISTING_DATABASE});
        }
        catch (IllegalArgumentException e) {
            throw new IncorrectUsage(e.getMessage());
        }
    }

    @Override
    public void doImport() throws IOException {
        this.copyDatabase(this.from, this.config);
        this.removeMessagesLog(this.config);
    }

    private void copyDatabase(File from, Config config) throws IOException {
        FileUtils.copyRecursively((File)from, (File)((File)config.get(DatabaseManagementSystemSettings.database_path)));
    }

    private void removeMessagesLog(Config config) {
        FileUtils.deleteFile((File)new File((File)config.get(DatabaseManagementSystemSettings.database_path), "messages.log"));
    }
}

