/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.archive;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.AccessDeniedException;
import java.nio.file.FileSystemException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;

public class Utils {
    private Utils() {
    }

    public static void checkWritableDirectory(Path directory) throws FileSystemException {
        if (!Files.exists(directory, new LinkOption[0])) {
            throw new NoSuchFileException(directory.toString());
        }
        if (Files.isRegularFile(directory, new LinkOption[0])) {
            throw new FileSystemException(directory.toString() + ": Not a directory");
        }
        if (!Files.isWritable(directory)) {
            throw new AccessDeniedException(directory.toString());
        }
    }

    public static void copy(InputStream in, OutputStream out) throws IOException {
        int n;
        byte[] buffer = new byte[8192];
        while (-1 != (n = in.read(buffer))) {
            out.write(buffer, 0, n);
        }
    }
}

