/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.archive;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.function.Predicate;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import org.neo4j.commandline.Util;
import org.neo4j.dbms.archive.Utils;
import org.neo4j.function.Predicates;
import org.neo4j.function.ThrowingAction;
import org.neo4j.io.fs.FileVisitors;

public class Dumper {
    public void dump(Path dbPath, Path transactionalLogsPath, Path archive, Predicate<Path> exclude) throws IOException {
        Utils.checkWritableDirectory(archive.getParent());
        try (ArchiveOutputStream stream = Dumper.openArchiveOut(archive);){
            this.visitPath(dbPath, exclude, stream);
            if (!Util.isSameOrChildPath((Path)dbPath, (Path)transactionalLogsPath)) {
                this.visitPath(transactionalLogsPath, exclude, stream);
            }
        }
    }

    private void visitPath(Path transactionalLogsPath, Predicate<Path> exclude, ArchiveOutputStream stream) throws IOException {
        Files.walkFileTree(transactionalLogsPath, FileVisitors.onlyMatching((Predicate)Predicates.not(exclude), (FileVisitor)FileVisitors.throwExceptions((FileVisitor)FileVisitors.onDirectory(dir -> this.dumpDirectory(transactionalLogsPath, stream, (Path)dir), (FileVisitor)FileVisitors.onFile(file -> this.dumpFile(transactionalLogsPath, stream, (Path)file), (FileVisitor)FileVisitors.justContinue())))));
    }

    private static ArchiveOutputStream openArchiveOut(Path archive) throws IOException {
        TarArchiveOutputStream tarball = new TarArchiveOutputStream((OutputStream)new GzipCompressorOutputStream(Files.newOutputStream(archive, StandardOpenOption.CREATE_NEW)));
        tarball.setLongFileMode(3);
        tarball.setBigNumberMode(2);
        return tarball;
    }

    private void dumpFile(Path root, ArchiveOutputStream stream, Path file) throws IOException {
        this.withEntry((ThrowingAction<IOException>)((ThrowingAction)() -> this.writeFile(file, stream)), root, stream, file);
    }

    private void dumpDirectory(Path root, ArchiveOutputStream stream, Path dir) throws IOException {
        this.withEntry((ThrowingAction<IOException>)ThrowingAction.noop(), root, stream, dir);
    }

    private void withEntry(ThrowingAction<IOException> operation, Path root, ArchiveOutputStream stream, Path file) throws IOException {
        ArchiveEntry entry = this.createEntry(file, root, stream);
        stream.putArchiveEntry(entry);
        operation.apply();
        stream.closeArchiveEntry();
    }

    private ArchiveEntry createEntry(Path file, Path root, ArchiveOutputStream archive) throws IOException {
        return archive.createArchiveEntry(file.toFile(), "./" + root.relativize(file).toString());
    }

    private void writeFile(Path file, ArchiveOutputStream archiveStream) throws IOException {
        try (InputStream in = Files.newInputStream(file, new OpenOption[0]);){
            Utils.copy(in, (OutputStream)archiveStream);
        }
    }
}

