/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.commandline.dbms;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.function.Predicate;
import org.neo4j.commandline.Util;
import org.neo4j.commandline.admin.AdminCommand;
import org.neo4j.commandline.admin.CommandFailed;
import org.neo4j.commandline.admin.IncorrectUsage;
import org.neo4j.commandline.arguments.Arguments;
import org.neo4j.commandline.dbms.CannotWriteException;
import org.neo4j.commandline.dbms.StoreLockChecker;
import org.neo4j.dbms.archive.CompressionFormat;
import org.neo4j.dbms.archive.Dumper;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.StoreLockException;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.pagecache.ConfigurableStandalonePageCacheFactory;
import org.neo4j.kernel.impl.recovery.RecoveryRequiredChecker;
import org.neo4j.kernel.impl.recovery.RecoveryRequiredException;
import org.neo4j.kernel.impl.scheduler.JobSchedulerFactory;
import org.neo4j.kernel.impl.util.Validators;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.scheduler.JobScheduler;

public class DumpCommand
implements AdminCommand {
    private static final Arguments arguments = new Arguments().withDatabase().withTo("Destination (file or folder) of database dump.");
    private final Path homeDir;
    private final Path configDir;
    private final Dumper dumper;

    public DumpCommand(Path homeDir, Path configDir, Dumper dumper) {
        this.homeDir = homeDir;
        this.configDir = configDir;
        this.dumper = dumper;
    }

    public void execute(String[] args) throws IncorrectUsage, CommandFailed {
        String database = arguments.parse(args).get("database");
        Path archive = DumpCommand.calculateArchive(database, arguments.getMandatoryPath("to"));
        Config config = this.buildConfig(database);
        Path databaseDirectory = Util.canonicalPath((Path)DumpCommand.getDatabaseDirectory(config));
        DatabaseLayout databaseLayout = DatabaseLayout.of((File)databaseDirectory.toFile());
        Path transactionLogsDirectory = Util.canonicalPath((Path)DumpCommand.getTransactionalLogsDirectory(config));
        try {
            Validators.CONTAINS_EXISTING_DATABASE.validate((Object)databaseLayout.databaseDirectory());
        }
        catch (IllegalArgumentException e) {
            throw new CommandFailed("database does not exist: " + database, (Throwable)e);
        }
        try (Closeable ignored = StoreLockChecker.check(databaseLayout.getStoreLayout());){
            DumpCommand.checkDbState(databaseLayout, config);
            this.dump(database, databaseLayout, transactionLogsDirectory, archive);
        }
        catch (StoreLockException e) {
            throw new CommandFailed("the database is in use -- stop Neo4j and try again", (Throwable)e);
        }
        catch (IOException e) {
            DumpCommand.wrapIOException(e);
        }
        catch (CannotWriteException e) {
            throw new CommandFailed("you do not have permission to dump the database -- is Neo4j running as a different user?", (Throwable)e);
        }
    }

    private static Path getDatabaseDirectory(Config config) {
        return ((File)config.get(GraphDatabaseSettings.database_path)).toPath();
    }

    private static Path getTransactionalLogsDirectory(Config config) {
        return ((File)config.get(GraphDatabaseSettings.logical_logs_location)).toPath();
    }

    private Config buildConfig(String databaseName) {
        return Config.fromFile((Path)this.configDir.resolve("neo4j.conf")).withHome(this.homeDir).withConnectorsDisabled().withNoThrowOnFileLoadFailure().withSetting(GraphDatabaseSettings.active_database, databaseName).build();
    }

    private static Path calculateArchive(String database, Path to) {
        return Files.isDirectory(to, new LinkOption[0]) ? to.resolve(database + ".dump") : to;
    }

    private void dump(String database, DatabaseLayout databaseLayout, Path transactionalLogsDirectory, Path archive) throws CommandFailed {
        Path databasePath = databaseLayout.databaseDirectory().toPath();
        try {
            File storeLockFile = databaseLayout.getStoreLayout().storeLockFile();
            Predicate<Path> pathPredicate = path -> Objects.equals(path.getFileName().toString(), storeLockFile.getName());
            this.dumper.dump(databasePath, transactionalLogsDirectory, archive, CompressionFormat.ZSTD, pathPredicate);
        }
        catch (FileAlreadyExistsException e) {
            throw new CommandFailed("archive already exists: " + e.getMessage(), (Throwable)e);
        }
        catch (NoSuchFileException e) {
            if (Paths.get(e.getMessage(), new String[0]).toAbsolutePath().equals(databasePath)) {
                throw new CommandFailed("database does not exist: " + database, (Throwable)e);
            }
            DumpCommand.wrapIOException(e);
        }
        catch (IOException e) {
            DumpCommand.wrapIOException(e);
        }
    }

    private static void checkDbState(DatabaseLayout databaseLayout, Config additionalConfiguration) throws CommandFailed {
        try (DefaultFileSystemAbstraction fileSystem = new DefaultFileSystemAbstraction();
             JobScheduler jobScheduler = JobSchedulerFactory.createInitialisedScheduler();
             PageCache pageCache = ConfigurableStandalonePageCacheFactory.createPageCache((FileSystemAbstraction)fileSystem, (Config)additionalConfiguration, (JobScheduler)jobScheduler);){
            RecoveryRequiredChecker.assertRecoveryIsNotRequired((FileSystemAbstraction)fileSystem, (PageCache)pageCache, (Config)additionalConfiguration, (DatabaseLayout)databaseLayout, (Monitors)new Monitors());
        }
        catch (RecoveryRequiredException rre) {
            throw new CommandFailed(rre.getMessage());
        }
        catch (Exception e) {
            throw new CommandFailed("Failure when checking for recovery state: '%s'." + e.getMessage(), (Throwable)e);
        }
    }

    private static void wrapIOException(IOException e) throws CommandFailed {
        throw new CommandFailed(String.format("unable to dump database: %s: %s", e.getClass().getSimpleName(), e.getMessage()), (Throwable)e);
    }

    public static Arguments arguments() {
        return arguments;
    }
}

