/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.archive;

import java.io.PrintStream;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.neo4j.graphdb.Resource;
import org.neo4j.io.ByteUnit;

class ArchiveProgressPrinter {
    private final AtomicBoolean printUpdate;
    private final PrintStream output;
    private final boolean interactive;
    private long currentBytes;
    private long currentFiles;
    private boolean done;
    long maxBytes;
    long maxFiles;

    ArchiveProgressPrinter(PrintStream output) {
        this.output = output;
        this.printUpdate = new AtomicBoolean();
        this.interactive = System.console() != null;
    }

    Resource startPrinting() {
        ScheduledExecutorService timer = Executors.newSingleThreadScheduledExecutor();
        ScheduledFuture<?> timerFuture = timer.scheduleAtFixedRate(this::printOnNextUpdate, 0L, this.interactive ? 100L : 5000L, TimeUnit.MILLISECONDS);
        return () -> {
            timerFuture.cancel(false);
            timer.shutdown();
            try {
                timer.awaitTermination(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.done();
            this.printProgress();
        };
    }

    void printOnNextUpdate() {
        this.printUpdate.set(true);
    }

    void reset() {
        this.maxBytes = 0L;
        this.maxFiles = 0L;
        this.currentBytes = 0L;
        this.currentFiles = 0L;
    }

    void beginFile() {
        ++this.currentFiles;
    }

    void addBytes(long n) {
        this.currentBytes += n;
        if (this.printUpdate.get()) {
            this.printProgress();
            this.printUpdate.set(false);
        }
    }

    void endFile() {
        this.printProgress();
    }

    void done() {
        this.done = true;
    }

    void printProgress() {
        if (this.output != null) {
            char lineSep;
            char c = lineSep = this.interactive ? (char)'\r' : '\n';
            if (this.done) {
                this.output.println(lineSep + "Done: " + this.currentFiles + " files, " + ByteUnit.bytesToString((long)this.currentBytes) + " processed.");
            } else if (this.maxFiles > 0L && this.maxBytes > 0L) {
                double progress = (double)this.currentBytes / (double)this.maxBytes * 100.0;
                this.output.print(lineSep + "Files: " + this.currentFiles + '/' + this.maxFiles + ", data: " + String.format("%4.1f%%", progress));
            } else {
                this.output.print(lineSep + "Files: " + this.currentFiles + "/?, data: ??.?%");
            }
        }
    }
}

