/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.commandline.dbms;

import java.nio.file.Path;
import javax.annotation.Nonnull;
import org.neo4j.commandline.admin.AdminCommand;
import org.neo4j.commandline.admin.AdminCommandSection;
import org.neo4j.commandline.admin.OutsideWorld;
import org.neo4j.commandline.arguments.Arguments;
import org.neo4j.commandline.dbms.DiagnosticsReportCommand;

public class DiagnosticsReportCommandProvider
extends AdminCommand.Provider {
    public DiagnosticsReportCommandProvider() {
        super("report", new String[0]);
    }

    @Nonnull
    public Arguments allArguments() {
        return DiagnosticsReportCommand.allArguments();
    }

    @Nonnull
    public String summary() {
        return "Produces a zip/tar of the most common information needed for remote assessments.";
    }

    @Nonnull
    public AdminCommandSection commandSection() {
        return AdminCommandSection.general();
    }

    @Nonnull
    public String description() {
        return "Will collect information about the system and package everything in an archive. If you specify 'all', everything will be included. You can also fine tune the selection by passing classifiers to the tool, e.g 'logs tx threads'. For a complete list of all available classifiers call the tool with the '--list' flag. If no classifiers are passed, the default list of `" + String.join((CharSequence)" ", DiagnosticsReportCommand.DEFAULT_CLASSIFIERS) + "` will be used.";
    }

    @Nonnull
    public AdminCommand create(Path homeDir, Path configDir, OutsideWorld outsideWorld) {
        return new DiagnosticsReportCommand(homeDir, configDir, outsideWorld);
    }
}

