/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.commandline.dbms;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.nio.file.Path;
import java.util.Locale;
import java.util.function.Function;
import java.util.function.ToDoubleFunction;
import org.neo4j.commandline.admin.AdminCommand;
import org.neo4j.commandline.admin.CommandFailed;
import org.neo4j.commandline.admin.IncorrectUsage;
import org.neo4j.commandline.admin.OutsideWorld;
import org.neo4j.commandline.arguments.Arguments;
import org.neo4j.commandline.arguments.NamedArgument;
import org.neo4j.commandline.arguments.OptionalNamedArg;
import org.neo4j.configuration.ExternalSettings;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.os.OsBeanUtil;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.configuration.Settings;
import org.neo4j.kernel.impl.store.StoreType;
import org.neo4j.kernel.internal.NativeIndexFileFilter;

public class MemoryRecommendationsCommand
implements AdminCommand {
    private static final Bracket[] datapoints = new Bracket[]{new Bracket(0.01, 0.007, 0.002), new Bracket(1.0, 0.65, 0.3), new Bracket(2.0, 1.0, 0.5), new Bracket(4.0, 1.5, 2.0), new Bracket(6.0, 2.0, 3.0), new Bracket(8.0, 2.5, 3.5), new Bracket(10.0, 3.0, 4.0), new Bracket(12.0, 3.5, 4.5), new Bracket(16.0, 4.0, 5.0), new Bracket(24.0, 6.0, 8.0), new Bracket(32.0, 8.0, 12.0), new Bracket(64.0, 12.0, 24.0), new Bracket(128.0, 16.0, 31.0), new Bracket(256.0, 20.0, 31.0), new Bracket(512.0, 24.0, 31.0), new Bracket(1024.0, 30.0, 31.0)};
    private static final String ARG_MEMORY = "memory";
    private final Path homeDir;
    private final OutsideWorld outsideWorld;
    private final Path configDir;

    static long recommendOsMemory(long totalMemoryBytes) {
        Brackets brackets = MemoryRecommendationsCommand.findMemoryBrackets(totalMemoryBytes);
        return brackets.recommend(Bracket::osMemory);
    }

    static long recommendHeapMemory(long totalMemoryBytes) {
        Brackets brackets = MemoryRecommendationsCommand.findMemoryBrackets(totalMemoryBytes);
        return brackets.recommend(Bracket::heapMemory);
    }

    static long recommendPageCacheMemory(long totalMemoryBytes) {
        long osMemory = MemoryRecommendationsCommand.recommendOsMemory(totalMemoryBytes);
        long heapMemory = MemoryRecommendationsCommand.recommendHeapMemory(totalMemoryBytes);
        long recommendation = totalMemoryBytes - osMemory - heapMemory;
        recommendation = Math.max(ByteUnit.mebiBytes((long)8L), recommendation);
        recommendation = Math.min(ByteUnit.tebiBytes((long)16L), recommendation);
        return recommendation;
    }

    private static Brackets findMemoryBrackets(long totalMemoryBytes) {
        double totalMemoryGB = (double)totalMemoryBytes / (double)ByteUnit.gibiBytes((long)1L);
        Bracket lower = null;
        Bracket upper = null;
        for (int i = 1; i < datapoints.length; ++i) {
            if (!(totalMemoryGB < datapoints[i].totalMemory)) continue;
            lower = datapoints[i - 1];
            upper = datapoints[i];
            break;
        }
        if (lower == null) {
            lower = datapoints[datapoints.length - 1];
            upper = datapoints[datapoints.length - 1];
        }
        return new Brackets(totalMemoryGB, lower, upper);
    }

    public static Arguments buildArgs() {
        String memory = MemoryRecommendationsCommand.bytesToString(OsBeanUtil.getTotalPhysicalMemory());
        return new Arguments().withArgument((NamedArgument)new OptionalNamedArg(ARG_MEMORY, memory, memory, "Recommend memory settings with respect to the given amount of memory, instead of the total memory of the system running the command.")).withDatabase("Name of specific database to calculate page cache memory requirement for. The generic calculation is still a good generic recommendation for this machine, but there will be an additional calculation for minimal required page cache memory for mapping all store and index files that are managed by the page cache.");
    }

    static String bytesToString(double bytes) {
        double gibi1 = ByteUnit.ONE_GIBI_BYTE;
        double mebi1 = ByteUnit.ONE_MEBI_BYTE;
        double mebi100 = 100.0 * mebi1;
        double kibi1 = ByteUnit.ONE_KIBI_BYTE;
        double kibi100 = 100.0 * kibi1;
        if (bytes >= gibi1) {
            double gibibytes = bytes / gibi1;
            double modMebi = bytes % gibi1;
            if (modMebi >= mebi100) {
                return String.format(Locale.ROOT, "%dm", Math.round(bytes / mebi100) * 100L);
            }
            return String.format(Locale.ROOT, "%.0fg", gibibytes);
        }
        if (bytes >= mebi1) {
            double mebibytes = bytes / mebi1;
            double modKibi = bytes % mebi1;
            if (modKibi >= kibi100) {
                return String.format(Locale.ROOT, "%dk", Math.round(bytes / kibi100) * 100L);
            }
            return String.format(Locale.ROOT, "%.0fm", mebibytes);
        }
        double kibiBytes = bytes / kibi1;
        return String.format(Locale.ROOT, "%dk", (long)Math.ceil(kibiBytes));
    }

    MemoryRecommendationsCommand(Path homeDir, Path configDir, OutsideWorld outsideWorld) {
        this.homeDir = homeDir;
        this.outsideWorld = outsideWorld;
        this.configDir = configDir;
    }

    public void execute(String[] args) throws IncorrectUsage, CommandFailed {
        Arguments arguments = MemoryRecommendationsCommand.buildArgs().parse(args);
        String mem = arguments.get(ARG_MEMORY);
        long memory = (Long)Settings.buildSetting((String)ARG_MEMORY, (Function)Settings.BYTES).build().apply(arg_0 -> ((Arguments)arguments).get(arg_0));
        String os = MemoryRecommendationsCommand.bytesToString(MemoryRecommendationsCommand.recommendOsMemory(memory));
        String heap = MemoryRecommendationsCommand.bytesToString(MemoryRecommendationsCommand.recommendHeapMemory(memory));
        String pagecache = MemoryRecommendationsCommand.bytesToString(MemoryRecommendationsCommand.recommendPageCacheMemory(memory));
        boolean specificDb = arguments.has("database");
        this.print("# Memory settings recommendation from neo4j-admin memrec:");
        this.print("#");
        this.print("# Assuming the system is dedicated to running Neo4j and has " + mem + " of memory,");
        this.print("# we recommend a heap size of around " + heap + ", and a page cache of around " + pagecache + ",");
        this.print("# and that about " + os + " is left for the operating system, and the native memory");
        this.print("# needed by Lucene and Netty.");
        this.print("#");
        this.print("# Tip: If the indexing storage use is high, e.g. there are many indexes or most");
        this.print("# data indexed, then it might advantageous to leave more memory for the");
        this.print("# operating system.");
        this.print("#");
        this.print("# Tip: The more concurrent transactions your workload has and the more updates");
        this.print("# they do, the more heap memory you will need. However, don't allocate more");
        this.print("# than 31g of heap, since this will disable pointer compression, also known as");
        this.print("# \"compressed oops\", in the JVM and make less effective use of the heap.");
        this.print("#");
        this.print("# Tip: Setting the initial and the max heap size to the same value means the");
        this.print("# JVM will never need to change the heap size. Changing the heap size otherwise");
        this.print("# involves a full GC, which is desirable to avoid.");
        this.print("#");
        this.print("# Based on the above, the following memory settings are recommended:");
        this.print(ExternalSettings.initialHeapSize.name() + "=" + heap);
        this.print(ExternalSettings.maxHeapSize.name() + "=" + heap);
        this.print(GraphDatabaseSettings.pagecache_memory.name() + "=" + pagecache);
        if (!specificDb) {
            return;
        }
        String databaseName = arguments.get("database");
        File configFile = this.configDir.resolve("neo4j.conf").toFile();
        File databaseDirectory = (File)this.getConfig(configFile, databaseName).get(GraphDatabaseSettings.database_path);
        DatabaseLayout layout = DatabaseLayout.of((File)databaseDirectory);
        long pageCacheSize = this.dbSpecificPageCacheSize(layout);
        long luceneSize = this.dbSpecificLuceneSize(databaseDirectory);
        this.print("#");
        this.print("# The numbers below have been derived based on your current data volume in database and index configuration of database '" + databaseName + "'.");
        this.print("# They can be used as an input into more detailed memory analysis.");
        this.print("# Lucene indexes: " + MemoryRecommendationsCommand.bytesToString(luceneSize));
        this.print("# Data volume and native indexes: " + MemoryRecommendationsCommand.bytesToString(pageCacheSize));
    }

    private long dbSpecificPageCacheSize(DatabaseLayout databaseLayout) {
        return this.sumStoreFiles(databaseLayout) + this.sumIndexFiles(IndexDirectoryStructure.baseSchemaIndexFolder((File)databaseLayout.databaseDirectory()), this.getNativeIndexFileFilter(databaseLayout.databaseDirectory(), false));
    }

    private long dbSpecificLuceneSize(File databaseDirectory) {
        return this.sumIndexFiles(IndexDirectoryStructure.baseSchemaIndexFolder((File)databaseDirectory), this.getNativeIndexFileFilter(databaseDirectory, true));
    }

    private FilenameFilter getNativeIndexFileFilter(File storeDir, boolean inverse) {
        NativeIndexFileFilter nativeIndexFilter = new NativeIndexFileFilter(storeDir);
        return (arg_0, arg_1) -> this.lambda$getNativeIndexFileFilter$0(inverse, (FileFilter)nativeIndexFilter, arg_0, arg_1);
    }

    private long sumStoreFiles(DatabaseLayout databaseLayout) {
        long total = 0L;
        for (StoreType type : StoreType.values()) {
            if (!type.isRecordStore()) continue;
            FileSystemAbstraction fileSystem = this.outsideWorld.fileSystem();
            total += databaseLayout.file(type.getDatabaseFile()).filter(arg_0 -> ((FileSystemAbstraction)fileSystem).fileExists(arg_0)).mapToLong(arg_0 -> ((FileSystemAbstraction)fileSystem).getFileSize(arg_0)).sum();
        }
        return total += this.sizeOfFileIfExists(databaseLayout.labelScanStore());
    }

    private long sizeOfFileIfExists(File file) {
        FileSystemAbstraction fileSystem = this.outsideWorld.fileSystem();
        return fileSystem.fileExists(file) ? fileSystem.getFileSize(file) : 0L;
    }

    private long sumIndexFiles(File file, FilenameFilter filter) {
        long total = 0L;
        if (this.outsideWorld.fileSystem().isDirectory(file)) {
            File[] children = this.outsideWorld.fileSystem().listFiles(file, filter);
            if (children != null) {
                for (File child : children) {
                    total += this.sumIndexFiles(child, filter);
                }
            }
        } else {
            total += this.outsideWorld.fileSystem().getFileSize(file);
        }
        return total;
    }

    private Config getConfig(File configFile, String databaseName) throws CommandFailed {
        if (!this.outsideWorld.fileSystem().fileExists(configFile)) {
            throw new CommandFailed("Unable to find config file, tried: " + configFile.getAbsolutePath());
        }
        try {
            return Config.fromFile((File)configFile).withHome(this.homeDir).withSetting(GraphDatabaseSettings.active_database, databaseName).withConnectorsDisabled().build();
        }
        catch (Exception e) {
            throw new CommandFailed("Failed to read config file: " + configFile.getAbsolutePath(), (Throwable)e);
        }
    }

    private void print(String text) {
        this.outsideWorld.stdOutLine(text);
    }

    private /* synthetic */ boolean lambda$getNativeIndexFileFilter$0(boolean inverse, FileFilter nativeIndexFilter, File dir, String name) {
        File file = new File(dir, name);
        if (this.outsideWorld.fileSystem().isDirectory(file)) {
            return true;
        }
        if (name.equals("failure-message")) {
            return false;
        }
        return inverse != nativeIndexFilter.accept(file);
    }

    private static final class Brackets {
        private final double totalMemoryGB;
        private final Bracket lower;
        private final Bracket upper;

        private Brackets(double totalMemoryGB, Bracket lower, Bracket upper) {
            this.totalMemoryGB = totalMemoryGB;
            this.lower = lower;
            this.upper = upper;
        }

        private double differenceFactor() {
            if (this.lower == this.upper) {
                return 0.0;
            }
            return (this.totalMemoryGB - this.lower.totalMemory) / (this.upper.totalMemory - this.lower.totalMemory);
        }

        public long recommend(ToDoubleFunction<Bracket> parameter) {
            double factor = this.differenceFactor();
            double lowerParam = parameter.applyAsDouble(this.lower);
            double upperParam = parameter.applyAsDouble(this.upper);
            double diff = upperParam - lowerParam;
            double recommend = lowerParam + diff * factor;
            return ByteUnit.mebiBytes((long)((long)(recommend * 1024.0)));
        }
    }

    private static final class Bracket {
        private final double totalMemory;
        private final double osMemory;
        private final double heapMemory;

        private Bracket(double totalMemory, double osMemory, double heapMemory) {
            this.totalMemory = totalMemory;
            this.osMemory = osMemory;
            this.heapMemory = heapMemory;
        }

        double osMemory() {
            return this.osMemory;
        }

        double heapMemory() {
            return this.heapMemory;
        }
    }
}

