/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.archive;

import com.github.luben.zstd.ZstdInputStream;
import com.github.luben.zstd.ZstdOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public enum CompressionFormat {
    GZIP{

        @Override
        public OutputStream compress(OutputStream stream) throws IOException {
            return new GZIPOutputStream(stream);
        }

        @Override
        public InputStream decompress(InputStream stream) throws IOException {
            return new GZIPInputStream(stream);
        }
    }
    ,
    ZSTD{
        private final byte[] HEADER = new byte[]{122, 115, 116, 100};

        @Override
        public OutputStream compress(OutputStream stream) throws IOException {
            ZstdOutputStream zstdout = new ZstdOutputStream(stream);
            zstdout.setChecksum(true);
            zstdout.write(this.HEADER);
            return zstdout;
        }

        @Override
        public InputStream decompress(InputStream stream) throws IOException {
            ZstdInputStream zstdin = new ZstdInputStream(stream);
            byte[] header = new byte[this.HEADER.length];
            if (zstdin.read(header) != this.HEADER.length || !Arrays.equals(header, this.HEADER)) {
                throw new IOException("Not in ZSTD format");
            }
            return zstdin;
        }
    };


    public abstract OutputStream compress(OutputStream var1) throws IOException;

    public abstract InputStream decompress(InputStream var1) throws IOException;
}

