/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.commandline.dbms;

import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.neo4j.commandline.dbms.CannotWriteException;
import org.neo4j.io.IOUtils;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.layout.Neo4jLayout;
import org.neo4j.kernel.internal.locker.DatabaseLocker;
import org.neo4j.kernel.internal.locker.FileLockException;
import org.neo4j.kernel.internal.locker.GlobalLocker;
import org.neo4j.kernel.internal.locker.Locker;

public class LockChecker
implements Closeable {
    private final FileSystemAbstraction fileSystem;
    private final Locker locker;

    private LockChecker(FileSystemAbstraction fileSystem, Locker locker) {
        this.fileSystem = fileSystem;
        this.locker = locker;
    }

    public static Closeable checkDbmsLock(Neo4jLayout neo4jLayout) throws CannotWriteException {
        DefaultFileSystemAbstraction fileSystem = new DefaultFileSystemAbstraction();
        GlobalLocker locker = new GlobalLocker((FileSystemAbstraction)fileSystem, neo4jLayout);
        return LockChecker.check((Locker)locker, (FileSystemAbstraction)fileSystem);
    }

    public static Closeable checkDatabaseLock(DatabaseLayout databaseLayout) throws CannotWriteException {
        DefaultFileSystemAbstraction fileSystem = new DefaultFileSystemAbstraction();
        DatabaseLocker locker = new DatabaseLocker((FileSystemAbstraction)fileSystem, databaseLayout);
        return LockChecker.check((Locker)locker, (FileSystemAbstraction)fileSystem);
    }

    private static Closeable check(Locker locker, FileSystemAbstraction fileSystem) throws CannotWriteException {
        Path lockFile = locker.lockFile().toPath();
        if (Files.isWritable(lockFile.getParent())) {
            if (Files.exists(lockFile, new LinkOption[0]) && !Files.isWritable(lockFile)) {
                throw new CannotWriteException(lockFile);
            }
            LockChecker lockChecker = new LockChecker(fileSystem, locker);
            try {
                lockChecker.checkLock();
                return lockChecker;
            }
            catch (FileLockException le) {
                try {
                    locker.close();
                }
                catch (IOException e) {
                    le.addSuppressed((Throwable)e);
                }
                throw le;
            }
        }
        throw new CannotWriteException(lockFile);
    }

    private void checkLock() {
        this.locker.checkLock();
    }

    @Override
    public void close() throws IOException {
        IOUtils.closeAll((AutoCloseable[])new Closeable[]{this.locker, this.fileSystem});
    }
}

