/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.commandline.dbms.storeutil;

import java.io.IOException;
import org.neo4j.commandline.dbms.storeutil.LenientStoreInputChunk;
import org.neo4j.commandline.dbms.storeutil.StoreCopyFilter;
import org.neo4j.commandline.dbms.storeutil.StoreCopyStats;
import org.neo4j.internal.batchimport.input.Group;
import org.neo4j.internal.batchimport.input.InputEntityVisitor;
import org.neo4j.kernel.impl.store.NodeLabelsField;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PrimitiveRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.token.TokenHolders;
import org.neo4j.token.api.TokenHolder;

class LenientNodeReader
extends LenientStoreInputChunk {
    private final NodeStore nodeStore;
    private final NodeRecord record;
    private final StoreCopyFilter.TokenLookup tokenLookup;

    LenientNodeReader(StoreCopyStats stats, NodeStore nodeStore, PropertyStore propertyStore, TokenHolders tokenHolders, StoreCopyFilter storeCopyFilter) {
        super(stats, propertyStore, tokenHolders, nodeStore.openPageCursorForReading(0L), storeCopyFilter);
        this.nodeStore = nodeStore;
        this.record = (NodeRecord)nodeStore.newRecord();
        TokenHolder tokenHolder = tokenHolders.labelTokens();
        this.tokenLookup = id -> tokenHolder.getTokenById(id).name();
    }

    @Override
    void readAndVisit(long id, InputEntityVisitor visitor) throws IOException {
        this.nodeStore.getRecordByCursor(id, (AbstractBaseRecord)this.record, RecordLoad.NORMAL, this.cursor);
        if (this.record.inUse()) {
            this.nodeStore.ensureHeavy(this.record);
            long[] labelIds = NodeLabelsField.parseLabelsField((NodeRecord)this.record).get(this.nodeStore);
            if (!this.storeCopyFilter.shouldDeleteNode(labelIds)) {
                String[] labels = this.storeCopyFilter.filterLabels(labelIds, this.tokenLookup);
                visitor.id((Object)id, Group.GLOBAL);
                visitor.labels(labels);
                this.visitPropertyChainNoThrow(visitor, (PrimitiveRecord)this.record);
                visitor.endOfEntity();
            } else {
                this.stats.removed.increment();
            }
        } else {
            this.stats.unused.increment();
        }
    }

    @Override
    String recordType() {
        return "Node";
    }
}

