/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.diagnostics.jmx;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Optional;
import org.neo4j.dbms.diagnostics.jmx.JmxDump;
import org.neo4j.dbms.diagnostics.jmx.LocalVirtualMachine;
import org.neo4j.io.fs.FileSystemAbstraction;

public class JMXDumper {
    private final Path homeDir;
    private final FileSystemAbstraction fs;
    private final PrintStream err;
    private final boolean verbose;
    private PrintStream out;

    public JMXDumper(Path homeDir, FileSystemAbstraction fs, PrintStream out, PrintStream err, boolean verbose) {
        this.homeDir = homeDir;
        this.fs = fs;
        this.err = err;
        this.verbose = verbose;
        this.out = out;
    }

    public Optional<JmxDump> getJMXDump() {
        this.out.println("Finding running instance of neo4j");
        Optional<Long> pid = this.getPid();
        if (pid.isPresent()) {
            return this.getJMXDump(pid.get());
        }
        this.out.println("No running instance of neo4j was found. Online reports will be omitted.");
        this.out.println("If neo4j is running but not detected, you can supply the process id of the running instance with --pid");
        return Optional.empty();
    }

    public Optional<JmxDump> getJMXDump(long pid) {
        try {
            LocalVirtualMachine vm = LocalVirtualMachine.from(pid);
            this.out.println("Attached to running process with process id " + pid);
            try {
                JmxDump jmxDump = JmxDump.connectTo(vm.getJmxAddress());
                jmxDump.attachSystemProperties(vm.getSystemProperties());
                this.out.println("Connected to JMX endpoint");
                return Optional.of(jmxDump);
            }
            catch (IOException e) {
                this.printError("Unable to communicate with JMX endpoint. Reason: " + e.getMessage(), e);
            }
        }
        catch (NoClassDefFoundError e) {
            this.printError("Unable to attach to process. Reason: JDK is not available, please point environment variable JAVA_HOME to a valid JDK location.", e);
        }
        catch (IOException e) {
            this.printError("Unable to connect to process with process id " + pid + ". Reason: " + e.getMessage(), e);
        }
        return Optional.empty();
    }

    private void printError(String message, Throwable e) {
        this.err.println(message);
        if (this.verbose && e != null) {
            e.printStackTrace(this.err);
        }
    }

    private void printError(String message) {
        this.printError(message, null);
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    private Optional<Long> getPid() {
        Path pidFile = this.homeDir.resolve("run/neo4j.pid");
        if (this.fs.fileExists(pidFile)) {
            try (InputStream inputStream = Files.newInputStream(pidFile, StandardOpenOption.READ);){
                BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
                String pidFileContent = reader.readLine();
                Optional<Long> optional = Optional.of(Long.parseLong(pidFileContent));
                reader.close();
                return optional;
                {
                    catch (NumberFormatException e) {
                        try {
                            this.printError(pidFile + " does not contain a valid id. Found: " + pidFileContent);
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            reader.close();
                        }
                    }
                }
            }
            catch (IOException e) {
                this.printError("Error reading the .pid file. Reason: " + e.getMessage(), e);
            }
        }
        return Optional.empty();
    }
}

