/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.database;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.configuration.helpers.SocketAddress;
import org.neo4j.dbms.DatabaseStateService;
import org.neo4j.dbms.database.DatabaseContextProvider;
import org.neo4j.dbms.database.DatabaseInfo;
import org.neo4j.dbms.database.DatabaseInfoService;
import org.neo4j.dbms.database.DetailedDatabaseInfo;
import org.neo4j.dbms.database.DetailedDbInfoProvider;
import org.neo4j.dbms.database.ExtendedDatabaseInfo;
import org.neo4j.dbms.database.readonly.ReadOnlyDatabases;
import org.neo4j.dbms.identity.ServerId;
import org.neo4j.dbms.systemgraph.TopologyGraphDbmsModel;
import org.neo4j.kernel.database.DatabaseId;
import org.neo4j.kernel.database.DatabaseIdRepository;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.storageengine.api.StoreId;

public class DefaultDatabaseInfoService
implements DatabaseInfoService {
    @Deprecated
    private static final String OLD_ROLE_LABEL = "standalone";
    private final DatabaseIdRepository idRepository;
    private final ReadOnlyDatabases readOnlyDatabases;
    private final ServerId serverId;
    private final SocketAddress address;
    private final DatabaseStateService stateService;
    private final DetailedDbInfoProvider detailedDbInfoProvider;

    public DefaultDatabaseInfoService(ServerId serverId, SocketAddress address, DatabaseContextProvider<?> databaseContextProvider, DatabaseStateService stateService, ReadOnlyDatabases readOnlyDatabases, DetailedDbInfoProvider detailedDbInfoProvider) {
        this.serverId = serverId;
        this.address = address;
        this.stateService = stateService;
        this.idRepository = databaseContextProvider.databaseIdRepository();
        this.readOnlyDatabases = readOnlyDatabases;
        this.detailedDbInfoProvider = detailedDbInfoProvider;
    }

    @Override
    public List<DatabaseInfo> lookupCachedInfo(Set<String> databaseNames) {
        return this.createDatabaseInfoStream(databaseNames).collect(Collectors.toList());
    }

    @Override
    public List<ExtendedDatabaseInfo> requestDetailedInfo(Set<String> databaseNames) {
        return this.createDatabaseInfoStream(databaseNames).map(databaseInfo -> {
            DatabaseId db = databaseInfo.namedDatabaseId.databaseId();
            long lastCommittedTxId = this.detailedDbInfoProvider.lastCommittedTxId(db);
            StoreId storeId = this.detailedDbInfoProvider.storeId(db);
            return databaseInfo.extendWith(new DetailedDatabaseInfo(lastCommittedTxId, storeId));
        }).collect(Collectors.toList());
    }

    private Stream<DatabaseInfo> createDatabaseInfoStream(Set<String> databaseNames) {
        return databaseNames.stream().map(arg_0 -> ((DatabaseIdRepository)this.idRepository).getByName(arg_0)).flatMap(Optional::stream).map(this::createInfoForDatabase);
    }

    private DatabaseInfo createInfoForDatabase(NamedDatabaseId namedDatabaseId) {
        String status = this.stateService.stateOfDatabase(namedDatabaseId).operatorState().description();
        String statusMessage = this.stateService.causeOfFailure(namedDatabaseId).map(Throwable::getMessage).orElse("");
        TopologyGraphDbmsModel.DatabaseAccess access = this.readOnlyDatabases.isReadOnly(namedDatabaseId) ? TopologyGraphDbmsModel.DatabaseAccess.READ_ONLY : TopologyGraphDbmsModel.DatabaseAccess.READ_WRITE;
        return new DatabaseInfo(namedDatabaseId, this.serverId, access, this.address, null, OLD_ROLE_LABEL, "primary", true, status, statusMessage);
    }
}

