/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.archive;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UncheckedIOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystemException;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.neo4j.commandline.dbms.StoreVersionLoader;
import org.neo4j.configuration.Config;
import org.neo4j.dbms.archive.ArchiveProgressPrinter;
import org.neo4j.dbms.archive.DecompressionSelector;
import org.neo4j.dbms.archive.DumpFormatSelector;
import org.neo4j.dbms.archive.IncorrectFormat;
import org.neo4j.dbms.archive.InvalidDumpEntryException;
import org.neo4j.dbms.archive.StandardCompressionFormat;
import org.neo4j.dbms.archive.Utils;
import org.neo4j.dbms.archive.printer.OutputProgressPrinter;
import org.neo4j.dbms.archive.printer.ProgressPrinters;
import org.neo4j.function.ThrowingSupplier;
import org.neo4j.graphdb.Resource;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogFiles;
import org.neo4j.storageengine.api.StorageEngineFactory;
import org.neo4j.util.VisibleForTesting;

public class Loader {
    private final FileSystemAbstraction filesystem;
    private final ArchiveProgressPrinter progressPrinter;

    @VisibleForTesting
    public Loader(FileSystemAbstraction filesystem) {
        this(filesystem, ProgressPrinters.emptyPrinter());
    }

    public Loader(FileSystemAbstraction filesystem, PrintStream output) {
        this(filesystem, output != null ? ProgressPrinters.printStreamPrinter(output) : ProgressPrinters.emptyPrinter());
    }

    public Loader(FileSystemAbstraction filesystem, OutputProgressPrinter progressPrinter) {
        this.filesystem = filesystem;
        this.progressPrinter = new ArchiveProgressPrinter(progressPrinter);
    }

    public void load(DatabaseLayout databaseLayout, ThrowingSupplier<InputStream, IOException> streamSupplier) throws IOException, IncorrectFormat {
        this.load(databaseLayout, streamSupplier, "");
    }

    public void load(DatabaseLayout databaseLayout, ThrowingSupplier<InputStream, IOException> streamSupplier, String inputName) throws IOException, IncorrectFormat {
        this.load(databaseLayout, false, true, DumpFormatSelector::decompress, streamSupplier, inputName);
    }

    public void load(Path archive, DatabaseLayout databaseLayout, boolean validateDatabaseExistence, boolean validateLogsExistence, DecompressionSelector selector) throws IOException, IncorrectFormat {
        this.load(databaseLayout, validateDatabaseExistence, validateLogsExistence, selector, (ThrowingSupplier<InputStream, IOException>)((ThrowingSupplier)() -> this.filesystem.openAsInputStream(archive)), archive.toString());
    }

    public void load(DatabaseLayout databaseLayout, boolean validateDatabaseExistence, boolean validateLogsExistence, DecompressionSelector selector, ThrowingSupplier<InputStream, IOException> streamSupplier, String inputName) throws IOException, IncorrectFormat {
        Path databaseDestination = databaseLayout.databaseDirectory();
        Path transactionLogsDirectory = databaseLayout.getTransactionLogsDirectory();
        Loader.validatePath(this.filesystem, databaseDestination, validateDatabaseExistence);
        Loader.validatePath(this.filesystem, transactionLogsDirectory, validateLogsExistence);
        Loader.createDestination(this.filesystem, databaseDestination);
        Loader.createDestination(this.filesystem, transactionLogsDirectory);
        Loader.checkDatabasePresence(this.filesystem, databaseLayout);
        try (ArchiveInputStream stream = this.openArchiveIn(selector, streamSupplier, inputName);
             Resource ignore = this.progressPrinter.startPrinting();){
            ArchiveEntry entry;
            while ((entry = Loader.nextEntry(stream, inputName)) != null) {
                Path destination = Loader.determineEntryDestination(entry, databaseDestination, transactionLogsDirectory);
                this.loadEntry(destination, stream, entry);
            }
        }
    }

    public StoreVersionLoader.Result getStoreVersion(FileSystemAbstraction fs, Config config, DatabaseLayout databaseLayout, CursorContextFactory contextFactory) {
        try (StoreVersionLoader stl = new StoreVersionLoader(fs, config, contextFactory);){
            StoreVersionLoader.Result result = stl.loadStoreVersionAndCheckDowngrade(databaseLayout);
            return result;
        }
    }

    public DumpMetaData getMetaData(ThrowingSupplier<InputStream, IOException> streamSupplier) throws IOException {
        try (InputStream decompressor = DumpFormatSelector.decompress(streamSupplier);){
            String format = "TAR+GZIP.";
            String files = "?";
            String bytes = "?";
            if (StandardCompressionFormat.ZSTD.isFormat(decompressor)) {
                format = "Neo4j ZSTD Dump.";
                this.readArchiveMetadata(decompressor);
                files = String.valueOf(this.progressPrinter.maxFiles);
                bytes = String.valueOf(this.progressPrinter.maxBytes);
            }
            DumpMetaData dumpMetaData = new DumpMetaData(format, files, bytes);
            return dumpMetaData;
        }
    }

    private static void checkDatabasePresence(FileSystemAbstraction filesystem, DatabaseLayout databaseLayout) throws FileAlreadyExistsException {
        if (StorageEngineFactory.selectStorageEngine((FileSystemAbstraction)filesystem, (DatabaseLayout)databaseLayout).isPresent()) {
            throw new FileAlreadyExistsException("Database already exists at location: " + databaseLayout.databaseDirectory());
        }
    }

    private static void createDestination(FileSystemAbstraction filesystem, Path destination) throws IOException {
        if (!filesystem.fileExists(destination)) {
            filesystem.mkdirs(destination);
        }
    }

    private static void validatePath(FileSystemAbstraction filesystem, Path path, boolean validateExistence) throws FileSystemException {
        if (validateExistence && filesystem.fileExists(path)) {
            throw new FileAlreadyExistsException(path.toString());
        }
        Utils.checkWritableDirectory(path.getParent());
    }

    private static Path determineEntryDestination(ArchiveEntry entry, Path databaseDestination, Path transactionLogsDirectory) {
        Path entryName = Path.of(entry.getName(), new String[0]).getFileName();
        try {
            return TransactionLogFiles.DEFAULT_FILENAME_FILTER.accept(entryName) ? transactionLogsDirectory : databaseDestination;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static ArchiveEntry nextEntry(ArchiveInputStream stream, String inputName) throws IncorrectFormat {
        try {
            return stream.getNextEntry();
        }
        catch (IOException e) {
            throw new IncorrectFormat(inputName, e);
        }
    }

    private void loadEntry(Path destination, ArchiveInputStream stream, ArchiveEntry entry) throws IOException {
        Path file = destination.resolve(entry.getName());
        if (!file.normalize().startsWith(destination)) {
            throw new InvalidDumpEntryException(entry.getName());
        }
        if (entry.isDirectory()) {
            this.filesystem.mkdirs(file);
        } else {
            try (OutputStream output = this.filesystem.openAsOutputStream(file, false);){
                Utils.copy((InputStream)stream, output, this.progressPrinter);
            }
        }
    }

    private ArchiveInputStream openArchiveIn(DecompressionSelector selector, ThrowingSupplier<InputStream, IOException> streamSupplier, String inputName) throws IOException, IncorrectFormat {
        try {
            InputStream decompressor = selector.decompress(streamSupplier);
            if (StandardCompressionFormat.ZSTD.isFormat(decompressor)) {
                this.readArchiveMetadata(decompressor);
            }
            return new TarArchiveInputStream(decompressor);
        }
        catch (NoSuchFileException ioe) {
            throw ioe;
        }
        catch (IOException e) {
            throw new IncorrectFormat(inputName, e);
        }
    }

    void readArchiveMetadata(InputStream stream) throws IOException {
        DataInputStream metadata = new DataInputStream(stream);
        int version = metadata.readInt();
        if (version != 1) {
            throw new IOException("Cannot read archive meta-data. I don't recognise this archive version: " + version + ".");
        }
        this.progressPrinter.maxFiles = metadata.readLong();
        this.progressPrinter.maxBytes = metadata.readLong();
    }

    public record DumpMetaData(String format, String fileCount, String byteCount) {
    }
}

