/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.diagnostics.profile;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.time.Duration;
import org.neo4j.dbms.diagnostics.jmx.JmxDump;
import org.neo4j.dbms.diagnostics.profile.PeriodicProfiler;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.time.SystemNanoClock;
import org.neo4j.util.VisibleForTesting;

public class JfrProfiler
extends PeriodicProfiler {
    private final Path dir;
    private final Duration maxDuration;
    private final JmxDump.JfrProfileConnection jfr;

    JfrProfiler(JmxDump dump, FileSystemAbstraction fs, Path dir, Duration duration, SystemNanoClock clock) {
        super(Duration.ofSeconds(3L), clock);
        this.dir = dir;
        this.maxDuration = duration.plus(Duration.ofMinutes(1L));
        try {
            fs.mkdirs(dir);
            this.jfr = dump.jfrConnection();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    protected void start() {
        String fileName = String.format("recording-%s.jfr", this.clock.instant().toString());
        this.jfr.start("Neo4j-Profiler-Recording", this.maxDuration, this.dir.resolve(fileName));
        super.start();
    }

    @Override
    protected void stop() {
        super.stop();
        this.jfr.stop();
    }

    @Override
    protected void tick() {
        if (!this.hasRunningRecording()) {
            throw new IllegalStateException("No JFR found running. Did server die?");
        }
    }

    @Override
    protected boolean available() {
        return true;
    }

    @VisibleForTesting
    boolean hasRunningRecording() {
        return this.jfr.isRunning();
    }
}

