/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.database;

import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.LongSupplier;
import java.util.stream.Collectors;
import org.neo4j.kernel.database.DatabaseId;
import org.neo4j.storageengine.api.ExternalStoreId;
import org.neo4j.storageengine.api.StoreId;

public record DatabaseDetailsExtras(Optional<Long> lastCommittedTxId, Optional<StoreId> storeId, Optional<ExternalStoreId> externalStoreId) {
    public static final DatabaseDetailsExtras EMPTY = new DatabaseDetailsExtras(Optional.empty(), Optional.empty(), Optional.empty());

    public static <T> Map<DatabaseId, Long> maxCommittedTxIds(Map<T, DatabaseDetailsExtras> extraDetails, Function<T, DatabaseId> databaseIdResolver) {
        return extraDetails.entrySet().stream().filter(e -> ((DatabaseDetailsExtras)e.getValue()).lastCommittedTxId().isPresent()).collect(Collectors.toMap(e -> (DatabaseId)databaseIdResolver.apply(e.getKey()), e -> ((DatabaseDetailsExtras)e.getValue()).lastCommittedTxId().orElse(0L), Math::max));
    }

    public Optional<Long> txCommitLag(long maxLastCommittedTxId) {
        if (maxLastCommittedTxId == -1L) {
            return this.lastCommittedTxId.map(c -> this.replace((Long)c, () -> 0L));
        }
        return this.lastCommittedTxId.map(c -> this.replace((Long)c, () -> c - maxLastCommittedTxId));
    }

    private Long replace(Long c, LongSupplier calculator) {
        return c == -1L ? -1L : calculator.getAsLong();
    }

    public boolean isEmpty() {
        return this.equals(EMPTY);
    }

    public void ifPresent(Consumer<DatabaseDetailsExtras> consumer) {
        if (!this.isEmpty()) {
            consumer.accept(this);
        }
    }
}

