/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.archive;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.neo4j.commandline.Util;
import org.neo4j.dbms.archive.ArchiveProgressPrinter;
import org.neo4j.dbms.archive.CompressionFormat;
import org.neo4j.dbms.archive.StandardCompressionFormat;
import org.neo4j.dbms.archive.Utils;
import org.neo4j.dbms.archive.printer.OutputProgressPrinter;
import org.neo4j.dbms.archive.printer.ProgressPrinters;
import org.neo4j.function.Predicates;
import org.neo4j.function.ThrowingConsumer;
import org.neo4j.graphdb.Resource;
import org.neo4j.io.fs.FileVisitors;
import org.neo4j.logging.InternalLogProvider;

public class Dumper {
    public static final String DUMP_EXTENSION = ".dump";
    private final List<ArchiveOperation> operations;
    private final ArchiveProgressPrinter progressPrinter;

    public Dumper() {
        this(ProgressPrinters.emptyPrinter());
    }

    public Dumper(PrintStream output) {
        this(ProgressPrinters.printStreamPrinter(output));
    }

    public Dumper(InternalLogProvider logProvider) {
        this(ProgressPrinters.logProviderPrinter(logProvider.getLog(Dumper.class)));
    }

    private Dumper(OutputProgressPrinter progressPrinter) {
        Objects.requireNonNull(progressPrinter);
        this.operations = new ArrayList<ArchiveOperation>();
        this.progressPrinter = new ArchiveProgressPrinter(progressPrinter);
    }

    public void dump(Path path, Path archive, CompressionFormat format) throws IOException {
        this.dump(path, path, this.openForDump(archive), format, Predicates.alwaysFalse());
    }

    public OutputStream openForDump(Path archive) throws IOException {
        return this.openForDump(archive, false);
    }

    public OutputStream openForDump(Path archive, boolean overwriteDestination) throws IOException {
        Utils.checkWritableDirectory(archive.getParent());
        if (overwriteDestination) {
            return Files.newOutputStream(archive, new OpenOption[0]);
        }
        return Files.newOutputStream(archive, StandardOpenOption.CREATE_NEW);
    }

    public void dump(Path dbPath, Path transactionalLogsPath, OutputStream out, CompressionFormat format, Predicate<Path> exclude) throws IOException {
        this.operations.clear();
        this.visitPath(dbPath, exclude);
        if (!Util.isSameOrChildFile((Path)dbPath, (Path)transactionalLogsPath)) {
            this.visitPath(transactionalLogsPath, exclude);
        }
        this.progressPrinter.reset();
        for (ArchiveOperation operation : this.operations) {
            this.progressPrinter.maxBytes += operation.size;
            this.progressPrinter.maxFiles = this.progressPrinter.maxFiles + (operation.isFile ? 1L : 0L);
        }
        try (ArchiveOutputStream stream = this.wrapArchiveOut(out, format);
             Resource ignore = this.progressPrinter.startPrinting();){
            for (ArchiveOperation operation : this.operations) {
                operation.addToArchive(stream);
            }
        }
    }

    private void visitPath(Path transactionalLogsPath, Predicate<Path> exclude) throws IOException {
        Files.walkFileTree(transactionalLogsPath, FileVisitors.onlyMatching(exclude.negate(), (FileVisitor)FileVisitors.throwExceptions((FileVisitor)FileVisitors.onDirectory(dir -> this.dumpDirectory(transactionalLogsPath, (Path)dir), (FileVisitor)FileVisitors.onFile(file -> this.dumpFile(transactionalLogsPath, (Path)file), (FileVisitor)FileVisitors.justContinue())))));
    }

    private ArchiveOutputStream wrapArchiveOut(OutputStream out, CompressionFormat format) throws IOException {
        OutputStream compress = format.compress(out);
        if (StandardCompressionFormat.ZSTD.isFormat(compress)) {
            this.writeArchiveMetadata(compress);
        }
        TarArchiveOutputStream tarball = new TarArchiveOutputStream(compress);
        tarball.setLongFileMode(3);
        tarball.setBigNumberMode(2);
        return tarball;
    }

    void writeArchiveMetadata(OutputStream stream) throws IOException {
        DataOutputStream metadata = new DataOutputStream(stream);
        metadata.writeInt(1);
        metadata.writeLong(this.progressPrinter.maxFiles);
        metadata.writeLong(this.progressPrinter.maxBytes);
    }

    private void dumpFile(Path root, Path file) throws IOException {
        this.withEntry((ThrowingConsumer<ArchiveOutputStream, IOException>)((ThrowingConsumer)stream -> this.writeFile(file, (ArchiveOutputStream)stream)), root, file);
    }

    private void dumpDirectory(Path root, Path dir) throws IOException {
        this.withEntry((ThrowingConsumer<ArchiveOutputStream, IOException>)((ThrowingConsumer)stream -> {}), root, dir);
    }

    private void withEntry(ThrowingConsumer<ArchiveOutputStream, IOException> operation, Path root, Path file) throws IOException {
        this.operations.add(new ArchiveOperation(operation, root, file));
    }

    private void writeFile(Path file, ArchiveOutputStream archiveStream) throws IOException {
        try (InputStream in = Files.newInputStream(file, new OpenOption[0]);){
            Utils.copy(in, (OutputStream)archiveStream, this.progressPrinter);
        }
    }

    private static class ArchiveOperation {
        final ThrowingConsumer<ArchiveOutputStream, IOException> operation;
        final long size;
        final boolean isFile;
        final Path root;
        final Path file;

        private ArchiveOperation(ThrowingConsumer<ArchiveOutputStream, IOException> operation, Path root, Path file) throws IOException {
            this.operation = operation;
            this.isFile = Files.isRegularFile(file, new LinkOption[0]);
            this.size = this.isFile ? Files.size(file) : 0L;
            this.root = root;
            this.file = file;
        }

        void addToArchive(ArchiveOutputStream stream) throws IOException {
            ArchiveEntry entry = ArchiveOperation.createEntry(this.file, this.root, stream);
            stream.putArchiveEntry(entry);
            this.operation.accept((Object)stream);
            stream.closeArchiveEntry();
        }

        private static ArchiveEntry createEntry(Path file, Path root, ArchiveOutputStream archive) throws IOException {
            return archive.createArchiveEntry(file.toFile(), "./" + root.relativize(file));
        }
    }
}

