/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.routing;

import java.util.Optional;
import org.neo4j.dbms.database.DatabaseContextProvider;
import org.neo4j.dbms.routing.DatabaseAvailabilityChecker;
import org.neo4j.kernel.database.DatabaseReferenceImpl;

public final class DefaultDatabaseAvailabilityChecker
implements DatabaseAvailabilityChecker {
    private final DatabaseContextProvider<?> databaseContextProvider;

    public DefaultDatabaseAvailabilityChecker(DatabaseContextProvider<?> databaseContextProvider) {
        this.databaseContextProvider = databaseContextProvider;
    }

    @Override
    public boolean isAvailable(DatabaseReferenceImpl.Internal databaseReference) {
        Optional databaseCtx = this.databaseContextProvider.getDatabaseContext(databaseReference.databaseId());
        return databaseCtx.map(ctx -> ctx.database().getDatabaseAvailabilityGuard().isAvailable()).orElse(false);
    }

    @Override
    public boolean isPresent(DatabaseReferenceImpl.Internal databaseReference) {
        return this.databaseContextProvider.getDatabaseContext(databaseReference.databaseId()).isPresent();
    }
}

