/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.archive.backup;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.neo4j.dbms.archive.backup.BackupCompressionFormat;
import org.neo4j.dbms.archive.backup.BackupDescription;
import org.neo4j.dbms.archive.backup.BackupMetadataV1;

public class BackupTarFormatV1
implements BackupCompressionFormat {
    static final String MAGIC_HEADER = "BTV1";
    private BackupMetadataV1 metadata;

    @Override
    public void setMetadata(BackupDescription description) {
        this.metadata = new BackupMetadataV1(description);
    }

    @Override
    public OutputStream compress(OutputStream stream) throws IOException {
        stream.write(MAGIC_HEADER.getBytes());
        this.metadata.writeToStreamV1(stream);
        return stream;
    }

    @Override
    public InputStream decompress(InputStream stream) throws IOException {
        BackupMetadataV1.readFromStream(stream);
        return stream;
    }

    @Override
    public BackupCompressionFormat.StreamWithDescription decompressAndDescribe(InputStream stream) throws IOException {
        BackupDescription description = BackupMetadataV1.readFromStream(stream).toBackupDescription();
        return new BackupCompressionFormat.StreamWithDescription(stream, description);
    }

    @Override
    public BackupDescription readMetadata(InputStream inputStream) throws IOException {
        return BackupMetadataV1.readFromStream(inputStream).toBackupDescription();
    }

    public String toString() {
        return "BackupTarFormatV1{metadata=" + this.metadata + "}";
    }
}

