/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.database;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.configuration.helpers.SocketAddress;
import org.neo4j.dbms.DatabaseStateService;
import org.neo4j.dbms.database.DatabaseInfo;
import org.neo4j.dbms.database.DatabaseInfoService;
import org.neo4j.dbms.database.DetailedDatabaseInfo;
import org.neo4j.dbms.database.DetailedDbInfoProvider;
import org.neo4j.dbms.database.ExtendedDatabaseInfo;
import org.neo4j.dbms.database.readonly.ReadOnlyDatabases;
import org.neo4j.dbms.identity.ServerId;
import org.neo4j.dbms.systemgraph.TopologyGraphDbmsModel;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.database.DatabaseId;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.storageengine.api.ExternalStoreId;
import org.neo4j.storageengine.api.StoreId;

public class DefaultDatabaseInfoService
implements DatabaseInfoService {
    private final ReadOnlyDatabases readOnlyDatabases;
    private final ServerId serverId;
    private final SocketAddress address;
    private final DatabaseStateService stateService;
    private final DetailedDbInfoProvider detailedDbInfoProvider;

    public DefaultDatabaseInfoService(ServerId serverId, SocketAddress address, DatabaseStateService stateService, ReadOnlyDatabases readOnlyDatabases, DetailedDbInfoProvider detailedDbInfoProvider) {
        this.serverId = serverId;
        this.address = address;
        this.stateService = stateService;
        this.readOnlyDatabases = readOnlyDatabases;
        this.detailedDbInfoProvider = detailedDbInfoProvider;
    }

    @Override
    public List<DatabaseInfo> lookupCachedInfo(Set<NamedDatabaseId> databaseIds, Transaction ignored) {
        return this.createDatabaseInfoStream(databaseIds).collect(Collectors.toList());
    }

    @Override
    public List<ExtendedDatabaseInfo> requestDetailedInfo(Set<NamedDatabaseId> databaseIds, Transaction ignored) {
        return this.createDatabaseInfoStream(databaseIds).map(databaseInfo -> {
            DatabaseId db = databaseInfo.namedDatabaseId.databaseId();
            long lastCommittedTxId = this.detailedDbInfoProvider.lastCommittedTxId(db);
            StoreId storeId = this.detailedDbInfoProvider.storeId(db);
            ExternalStoreId externalStoreId = this.detailedDbInfoProvider.externalStoreId(db);
            return databaseInfo.extendWith(new DetailedDatabaseInfo(lastCommittedTxId, storeId, externalStoreId));
        }).collect(Collectors.toList());
    }

    private Stream<DatabaseInfo> createDatabaseInfoStream(Set<NamedDatabaseId> databaseIds) {
        return databaseIds.stream().map(this::createInfoForDatabase);
    }

    private DatabaseInfo createInfoForDatabase(NamedDatabaseId namedDatabaseId) {
        String status = this.stateService.stateOfDatabase(namedDatabaseId).operatorState().description();
        String statusMessage = this.stateService.causeOfFailure(namedDatabaseId).map(Throwable::getMessage).orElse("");
        TopologyGraphDbmsModel.DatabaseAccess access = this.readOnlyDatabases.isReadOnly(namedDatabaseId.databaseId()) ? TopologyGraphDbmsModel.DatabaseAccess.READ_ONLY : TopologyGraphDbmsModel.DatabaseAccess.READ_WRITE;
        return new DatabaseInfo(namedDatabaseId, this.serverId, access, this.address, null, "primary", true, status, statusMessage);
    }
}

