/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.database;

import java.security.NoSuchAlgorithmException;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import org.neo4j.configuration.helpers.SocketAddress;
import org.neo4j.dbms.database.DatabaseInfo;
import org.neo4j.dbms.identity.ServerId;
import org.neo4j.dbms.systemgraph.TopologyGraphDbmsModel;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.storageengine.api.ExternalStoreId;
import org.neo4j.storageengine.api.StoreId;
import org.neo4j.storageengine.util.StoreIdDecodeUtils;

public class ExtendedDatabaseInfo
extends DatabaseInfo {
    public static final long COMMITTED_TX_ID_NOT_AVAILABLE = -1L;
    private final long lastCommittedTxId;
    private final long txCommitLag;
    private final boolean committedTxIdNotAvailable;
    private final StoreId storeId;
    private final int primariesCount;
    private final int secondariesCount;
    private final ExternalStoreId externalStoreId;

    public ExtendedDatabaseInfo(NamedDatabaseId namedDatabaseId, ServerId serverId, TopologyGraphDbmsModel.DatabaseAccess accessFromConfig, SocketAddress boltAddress, SocketAddress catchupAddress, String role, boolean writer, String status, String statusMessage, long lastCommittedTxId, long txCommitLag, StoreId storeId, int primariesCount, int secondariesCount, ExternalStoreId externalStoreId) {
        super(namedDatabaseId, serverId, accessFromConfig, boltAddress, catchupAddress, role, writer, status, statusMessage);
        this.committedTxIdNotAvailable = lastCommittedTxId == -1L;
        this.lastCommittedTxId = this.committedTxIdNotAvailable ? 0L : lastCommittedTxId;
        this.txCommitLag = this.committedTxIdNotAvailable ? 0L : txCommitLag;
        this.storeId = storeId;
        this.primariesCount = primariesCount;
        this.secondariesCount = secondariesCount;
        this.externalStoreId = externalStoreId;
    }

    public OptionalLong lastCommittedTxId() {
        return this.committedTxIdNotAvailable ? OptionalLong.empty() : OptionalLong.of(this.lastCommittedTxId);
    }

    public OptionalLong txCommitLag() {
        return this.committedTxIdNotAvailable ? OptionalLong.empty() : OptionalLong.of(this.txCommitLag);
    }

    public Optional<String> storeId() {
        return this.storeId.equals((Object)StoreId.UNKNOWN) ? Optional.empty() : Optional.of(this.storeId.getStoreVersionUserString());
    }

    public Optional<String> externalStoreId() {
        if (this.externalStoreId == null) {
            return Optional.empty();
        }
        try {
            return Optional.of(StoreIdDecodeUtils.decodeId((ExternalStoreId)this.externalStoreId));
        }
        catch (NoSuchAlgorithmException e) {
            return Optional.empty();
        }
    }

    public int primariesCount() {
        return this.primariesCount;
    }

    public int secondariesCount() {
        return this.secondariesCount;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ExtendedDatabaseInfo that = (ExtendedDatabaseInfo)o;
        return this.lastCommittedTxId == that.lastCommittedTxId && this.txCommitLag == that.txCommitLag && this.committedTxIdNotAvailable == that.committedTxIdNotAvailable && this.primariesCount == that.primariesCount && this.secondariesCount == that.secondariesCount && Objects.equals(this.storeId, that.storeId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.lastCommittedTxId, this.txCommitLag, this.committedTxIdNotAvailable, this.storeId, this.primariesCount, this.secondariesCount);
    }

    @Override
    public String toString() {
        return "ExtendedDatabaseInfo{lastCommittedTxId=" + this.lastCommittedTxId + ", txCommitLag=" + this.txCommitLag + ", committedTxIdNotAvailable=" + this.committedTxIdNotAvailable + ", storeId=" + this.storeId + ", primariesCount=" + this.primariesCount + ", secondariesCount=" + this.secondariesCount + ", namedDatabaseId=" + this.namedDatabaseId + ", serverId=" + this.serverId + ", access=" + this.access + ", boltAddress=" + this.boltAddress + ", catchupAddress=" + this.catchupAddress + ", role='" + this.role + "', writer=" + this.writer + ", status='" + this.status + "', statusMessage='" + this.statusMessage + "'}";
    }
}

