/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.commandline.dbms;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.text.StringEscapeUtils;
import org.jutils.jprocesses.JProcesses;
import org.jutils.jprocesses.model.ProcessInfo;
import org.neo4j.cli.AbstractAdminCommand;
import org.neo4j.cli.CommandFailedException;
import org.neo4j.cli.ExecutionContext;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.diagnostics.jmx.JMXDumper;
import org.neo4j.dbms.diagnostics.jmx.JmxDump;
import org.neo4j.dbms.diagnostics.profile.ProfileCommand;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.diagnostics.DiagnosticsReportSource;
import org.neo4j.kernel.diagnostics.DiagnosticsReportSources;
import org.neo4j.kernel.diagnostics.DiagnosticsReporter;
import org.neo4j.kernel.diagnostics.DiagnosticsReporterProgress;
import org.neo4j.kernel.diagnostics.InteractiveProgress;
import org.neo4j.kernel.diagnostics.NonInteractiveProgress;
import picocli.CommandLine;

@CommandLine.Command(name="report", header={"Produces a zip/tar of the most common information needed for remote assessments."}, description={"Will collect information about the system and package everything in an archive. If you specify 'all', everything will be included. You can also fine tune the selection by passing classifiers to the tool, e.g 'logs tx threads'."}, subcommands={ProfileCommand.class})
public class DiagnosticsReportCommand
extends AbstractAdminCommand {
    static final String[] DEFAULT_CLASSIFIERS = new String[]{"logs", "config", "plugins", "tree", "metrics", "threads", "sysprop", "ps", "version"};
    private static final DateTimeFormatter filenameDateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd_HHmmss");
    @CommandLine.Option(names={"--list"}, description={"List all available classifiers"})
    private boolean list;
    @CommandLine.Option(names={"--ignore-disk-space-check"}, defaultValue="false", arity="0..1", paramLabel="true|false", fallbackValue="true", showDefaultValue=CommandLine.Help.Visibility.ALWAYS, description={"Ignore disk full warning"})
    private boolean ignoreDiskSpaceCheck;
    @CommandLine.Option(names={"--to-path"}, paramLabel="<path>", description={"Destination directory for reports. Defaults to a system tmp directory."})
    private Path reportDir;
    @CommandLine.Parameters(arity="0..*", paramLabel="<classifier>")
    private Set<String> classifiers = new TreeSet<String>(List.of(DEFAULT_CLASSIFIERS));
    private JMXDumper jmxDumper;

    public DiagnosticsReportCommand(ExecutionContext ctx) {
        super(ctx);
    }

    public void execute() {
        Config config = this.getConfig();
        this.jmxDumper = new JMXDumper(config, this.ctx.fs(), this.ctx.out(), this.ctx.err(), this.verbose);
        DiagnosticsReporter reporter = this.createAndRegisterSources(config);
        if (this.list) {
            this.listClassifiers(reporter.getAvailableClassifiers());
            return;
        }
        this.validateClassifiers(reporter);
        DiagnosticsReporterProgress progress = this.buildProgress();
        try {
            if (this.reportDir == null) {
                this.reportDir = Path.of(System.getProperty("java.io.tmpdir"), new String[0]).resolve("reports").toAbsolutePath();
            }
            Path reportFile = this.reportDir.resolve(DiagnosticsReportCommand.getDefaultFilename());
            this.ctx.out().println("Writing report to " + reportFile.toAbsolutePath());
            reporter.dump(this.classifiers, reportFile, progress, this.ignoreDiskSpaceCheck);
        }
        catch (IOException e) {
            throw new CommandFailedException("Creating archive failed", (Throwable)e);
        }
    }

    private static String getDefaultFilename() throws UnknownHostException {
        String hostName = InetAddress.getLocalHost().getHostName();
        String safeFilename = hostName.replaceAll("[^a-zA-Z0-9._]+", "_");
        return safeFilename + "-" + LocalDateTime.now().format(filenameDateTimeFormatter) + ".zip";
    }

    private DiagnosticsReporterProgress buildProgress() {
        return System.console() == null ? new NonInteractiveProgress(this.ctx.out(), this.verbose) : new InteractiveProgress(this.ctx.out(), this.verbose);
    }

    private void validateClassifiers(DiagnosticsReporter reporter) {
        Set availableClassifiers = reporter.getAvailableClassifiers();
        if (this.classifiers.contains("all")) {
            if (this.classifiers.size() != 1) {
                this.classifiers.remove("all");
                throw new CommandFailedException("If you specify 'all' this has to be the only classifier. Found ['" + String.join((CharSequence)"','", this.classifiers) + "'] as well.");
            }
        } else {
            if (this.classifiers.equals(Set.of(DEFAULT_CLASSIFIERS))) {
                this.classifiers = new HashSet<String>(this.classifiers);
                this.classifiers.retainAll(availableClassifiers);
            }
            DiagnosticsReportCommand.validateOrphanClassifiers(availableClassifiers, this.classifiers);
        }
    }

    private static void validateOrphanClassifiers(Set<String> availableClassifiers, Set<String> orphans) {
        for (String classifier : orphans) {
            if (availableClassifiers.contains(classifier)) continue;
            throw new CommandFailedException("Unknown classifier: " + classifier);
        }
    }

    private void listClassifiers(Set<String> availableClassifiers) {
        this.ctx.out().println("All available classifiers:");
        for (String classifier : availableClassifiers) {
            this.ctx.out().printf("  %-10s %s%n", classifier, DiagnosticsReportCommand.describeClassifier(classifier));
        }
    }

    private DiagnosticsReporter createAndRegisterSources(Config config) {
        DiagnosticsReporter reporter = new DiagnosticsReporter();
        Path storeDirectory = (Path)config.get(GraphDatabaseInternalSettings.databases_root_path);
        reporter.registerAllOfflineProviders(config, storeDirectory, this.ctx.fs(), (String)config.get(GraphDatabaseSettings.initial_default_database));
        reporter.registerSource("config", DiagnosticsReportSources.newDiagnosticsFile((String)"config/neo4j.conf", (FileSystemAbstraction)this.ctx.fs(), (Path)this.configFile()));
        DiagnosticsReportSources.newDiagnosticsMatchingFiles((String)"config/", (FileSystemAbstraction)this.ctx.fs(), (Path)this.ctx.confDir(), path -> {
            String fileName = path.getFileName().toString();
            return fileName.startsWith("neo4j-admin") && fileName.endsWith(".conf");
        }).forEach(conf -> reporter.registerSource("config", conf));
        Path serverLogsConfig = (Path)config.get(GraphDatabaseSettings.server_logging_config_path);
        if (this.ctx.fs().fileExists(serverLogsConfig)) {
            reporter.registerSource("config", DiagnosticsReportSources.newDiagnosticsFile((String)"config/server-logs.xml", (FileSystemAbstraction)this.ctx.fs(), (Path)serverLogsConfig));
        }
        Path userLogsConfig = (Path)config.get(GraphDatabaseSettings.user_logging_config_path);
        if (this.ctx.fs().fileExists(userLogsConfig)) {
            reporter.registerSource("config", DiagnosticsReportSources.newDiagnosticsFile((String)"config/user-logs.xml", (FileSystemAbstraction)this.ctx.fs(), (Path)userLogsConfig));
        }
        reporter.registerSource("ps", DiagnosticsReportCommand.runningProcesses());
        this.registerJMXSources(reporter);
        return reporter;
    }

    private Path configFile() {
        return this.ctx.confDir().resolve("neo4j.conf");
    }

    private void registerJMXSources(DiagnosticsReporter reporter) {
        Optional<JmxDump> jmxDump = this.jmxDumper.getJMXDump();
        jmxDump.ifPresent(jmx -> {
            reporter.registerSource("threads", jmx.threadDumpSource());
            reporter.registerSource("heap", jmx.heapDump());
            reporter.registerSource("sysprop", jmx.systemProperties());
        });
    }

    private Config getConfig() {
        return this.createPrefilledConfigBuilder().build();
    }

    static String describeClassifier(String classifier) {
        switch (classifier) {
            case "logs": {
                return "include log files";
            }
            case "config": {
                return "include configuration files";
            }
            case "plugins": {
                return "include a view of the plugin directory";
            }
            case "tree": {
                return "include a view of the tree structure of the data directory";
            }
            case "tx": {
                return "include transaction logs";
            }
            case "metrics": {
                return "include metrics";
            }
            case "threads": {
                return "include a thread dump of the running instance";
            }
            case "heap": {
                return "include a heap dump";
            }
            case "sysprop": {
                return "include a list of java system properties";
            }
            case "raft": {
                return "include the raft log";
            }
            case "ccstate": {
                return "include the current cluster state";
            }
            case "ps": {
                return "include a list of running processes";
            }
            case "version": {
                return "include version of neo4j";
            }
        }
        throw new IllegalArgumentException("Unknown classifier: " + classifier);
    }

    private static DiagnosticsReportSource runningProcesses() {
        return DiagnosticsReportSources.newDiagnosticsString((String)"ps.csv", () -> {
            List processesList = JProcesses.getProcessList();
            StringBuilder sb = new StringBuilder();
            sb.append(StringEscapeUtils.escapeCsv((String)"Process PID")).append(',').append(StringEscapeUtils.escapeCsv((String)"Process Name")).append(',').append(StringEscapeUtils.escapeCsv((String)"Process Time")).append(',').append(StringEscapeUtils.escapeCsv((String)"User")).append(',').append(StringEscapeUtils.escapeCsv((String)"Virtual Memory")).append(',').append(StringEscapeUtils.escapeCsv((String)"Physical Memory")).append(',').append(StringEscapeUtils.escapeCsv((String)"CPU usage")).append(',').append(StringEscapeUtils.escapeCsv((String)"Start Time")).append(',').append(StringEscapeUtils.escapeCsv((String)"Priority")).append(',').append(StringEscapeUtils.escapeCsv((String)"Full command")).append('\n');
            for (ProcessInfo processInfo : processesList) {
                sb.append(processInfo.getPid()).append(',').append(StringEscapeUtils.escapeCsv((String)processInfo.getName())).append(',').append(processInfo.getTime()).append(',').append(StringEscapeUtils.escapeCsv((String)processInfo.getUser())).append(',').append(processInfo.getVirtualMemory()).append(',').append(processInfo.getPhysicalMemory()).append(',').append(processInfo.getCpuUsage()).append(',').append(processInfo.getStartTime()).append(',').append(processInfo.getPriority()).append(',').append(StringEscapeUtils.escapeCsv((String)processInfo.getCommand())).append('\n');
            }
            return sb.toString();
        });
    }
}

