/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.diagnostics.profile;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BooleanSupplier;
import org.neo4j.dbms.diagnostics.profile.Profiler;
import org.neo4j.util.Preconditions;
import org.neo4j.util.concurrent.BinaryLatch;

abstract class ContinuousProfiler
extends Profiler {
    private Thread worker;
    private final AtomicBoolean stopFlag = new AtomicBoolean();
    private final BinaryLatch startLatch = new BinaryLatch();

    ContinuousProfiler() {
    }

    @Override
    protected void start() {
        Preconditions.checkState((this.worker == null ? 1 : 0) != 0, (String)"Already started");
        this.stopFlag.set(false);
        this.worker = new Thread(this::internalRun);
        this.worker.setName(this.getClass().getSimpleName() + " worker");
        this.worker.start();
        this.startLatch.await();
    }

    private void internalRun() {
        this.startLatch.release();
        try {
            this.run(this.stopFlag::get);
        }
        catch (RuntimeException exception) {
            this.setFailure(exception);
        }
    }

    protected abstract void run(BooleanSupplier var1);

    @Override
    protected void stop() {
        Preconditions.checkState((this.worker != null ? 1 : 0) != 0, (String)"Not started");
        this.stopFlag.set(true);
        try {
            this.worker.join(TimeUnit.MINUTES.toMillis(1L));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        if (this.worker.isAlive()) {
            throw new IllegalStateException(this.worker.getName() + " failed to stop");
        }
    }
}

