/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.commandline.dbms;

import java.io.IOException;
import java.io.UncheckedIOException;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.graphdb.config.Configuration;
import org.neo4j.internal.helpers.Exceptions;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.IOUtils;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.database.DatabaseTracers;
import org.neo4j.kernel.impl.pagecache.ConfiguringPageCacheFactory;
import org.neo4j.kernel.impl.scheduler.JobSchedulerFactory;
import org.neo4j.kernel.impl.transaction.log.entry.UnsupportedLogVersionException;
import org.neo4j.kernel.recovery.LogTailExtractor;
import org.neo4j.logging.InternalLog;
import org.neo4j.logging.NullLog;
import org.neo4j.logging.internal.LogService;
import org.neo4j.logging.internal.NullLogService;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryPools;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.storageengine.api.StorageEngineFactory;
import org.neo4j.storageengine.api.StoreVersionCheck;
import org.neo4j.storageengine.api.StoreVersionIdentifier;
import org.neo4j.time.Clocks;

public class StoreVersionLoader
implements AutoCloseable {
    private final FileSystemAbstraction fs;
    private final Config config;
    private final CursorContextFactory contextFactory;
    private final JobScheduler jobScheduler;
    private final PageCache pageCache;

    public StoreVersionLoader(FileSystemAbstraction fs, Config config, CursorContextFactory contextFactory) {
        this.fs = fs;
        this.config = Config.newBuilder().fromConfig(config).set(GraphDatabaseSettings.pagecache_memory, (Object)ByteUnit.mebiBytes((long)8L)).build();
        this.contextFactory = contextFactory;
        this.jobScheduler = JobSchedulerFactory.createInitialisedScheduler();
        this.pageCache = new ConfiguringPageCacheFactory(fs, config, PageCacheTracer.NULL, (InternalLog)NullLog.getInstance(), this.jobScheduler, Clocks.nanoClock(), new MemoryPools()).getOrCreatePageCache();
    }

    @Override
    public void close() {
        IOUtils.closeAllSilently((AutoCloseable[])new AutoCloseable[]{this.pageCache, this.jobScheduler});
    }

    public Result loadStoreVersionAndCheckDowngrade(DatabaseLayout layout) {
        StorageEngineFactory sef = StorageEngineFactory.selectStorageEngine((FileSystemAbstraction)this.fs, (DatabaseLayout)layout).orElseGet(() -> StorageEngineFactory.selectStorageEngine((Configuration)this.config));
        StoreVersionCheck versionCheck = sef.versionCheck(this.fs, layout, this.config, this.pageCache, (LogService)NullLogService.getInstance(), this.contextFactory);
        try (CursorContext cursorContext = this.contextFactory.create("Store version loader");){
            StoreVersionCheck.UpgradeCheckResult checkResult = versionCheck.getAndCheckUpgradeTargetVersion(cursorContext);
            if (checkResult.outcome() == StoreVersionCheck.UpgradeOutcome.STORE_VERSION_RETRIEVAL_FAILURE) {
                throw new IllegalStateException("Can not read store version of database " + layout.getDatabaseName(), checkResult.cause());
            }
            this.checkDowngrade(sef, layout);
            Result result = new Result(checkResult.outcome() == StoreVersionCheck.UpgradeOutcome.UNSUPPORTED_TARGET_VERSION, checkResult.versionToUpgradeFrom(), checkResult.versionToUpgradeTo(), versionCheck.getIntroductionVersionFromVersion(checkResult.versionToUpgradeFrom()));
            return result;
        }
    }

    private void checkDowngrade(StorageEngineFactory engineFactory, DatabaseLayout layout) {
        try {
            new LogTailExtractor(this.fs, this.pageCache, this.config, engineFactory, DatabaseTracers.EMPTY).getTailMetadata(layout, (MemoryTracker)EmptyMemoryTracker.INSTANCE, () -> KernelVersion.getLatestVersion((Config)this.config));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        catch (RuntimeException e) {
            if (Exceptions.contains((Throwable)e, ex -> ex instanceof UnsupportedLogVersionException)) {
                Throwable cause = e;
                while (!(cause instanceof UnsupportedLogVersionException)) {
                    cause = cause.getCause();
                }
                throw new IllegalStateException("The loaded database '" + layout.getDatabaseName() + "' is of a newer version than the current binaries. Downgrade is not supported.", cause);
            }
            throw e;
        }
    }

    public static class Result {
        public final StoreVersionIdentifier currentFormat;
        public final StoreVersionIdentifier latestFormat;
        public final boolean migrationNeeded;
        public final String currentFormatIntroductionVersion;

        private Result(boolean migrationNeeded, StoreVersionIdentifier currentFormat, StoreVersionIdentifier latestFormat, String currentFormatIntroductionVersion) {
            this.currentFormat = currentFormat;
            this.latestFormat = latestFormat;
            this.migrationNeeded = migrationNeeded;
            this.currentFormatIntroductionVersion = currentFormatIntroductionVersion;
        }
    }
}

