/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.routing;

import org.neo4j.dbms.routing.DatabaseAvailabilityChecker;
import org.neo4j.dbms.routing.RoutingException;
import org.neo4j.dbms.routing.RoutingTableServiceHelpers;
import org.neo4j.dbms.routing.RoutingTableServiceValidator;
import org.neo4j.kernel.database.DatabaseReference;

public class LocalRoutingTableServiceValidator
implements RoutingTableServiceValidator {
    private final DatabaseAvailabilityChecker databaseAvailabilityChecker;

    public LocalRoutingTableServiceValidator(DatabaseAvailabilityChecker databaseAvailabilityChecker) {
        this.databaseAvailabilityChecker = databaseAvailabilityChecker;
    }

    @Override
    public void isValidForServerSideRouting(DatabaseReference.Internal databaseReference) throws RoutingException {
        this.assertDatabaseIsOperational(databaseReference);
    }

    @Override
    public void isValidForClientSideRouting(DatabaseReference.Internal databaseReference) throws RoutingException {
        this.assertDatabaseIsOperational(databaseReference);
    }

    private void assertDatabaseIsOperational(DatabaseReference.Internal databaseReference) throws RoutingException {
        if (!this.databaseAvailabilityChecker.isPresent(databaseReference)) {
            throw RoutingTableServiceHelpers.databaseNotFoundException(databaseReference.alias().name());
        }
        if (!this.databaseAvailabilityChecker.isAvailable(databaseReference)) {
            throw RoutingTableServiceHelpers.databaseNotAvailableException(databaseReference.alias().name());
        }
    }
}

