/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.enterprise;

import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.kernel.api.bolt.BoltConnectionTracker;
import org.neo4j.kernel.api.exceptions.KernelException;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.enterprise.api.security.EnterpriseAuthManager;
import org.neo4j.kernel.enterprise.builtinprocs.EnterpriseBuiltInDbmsProcedures;
import org.neo4j.kernel.impl.constraints.ConstraintSemantics;
import org.neo4j.kernel.impl.enterprise.EnterpriseConstraintSemantics;
import org.neo4j.kernel.impl.enterprise.StandardBoltConnectionTracker;
import org.neo4j.kernel.impl.enterprise.configuration.EnterpriseEditionSettings;
import org.neo4j.kernel.impl.enterprise.id.EnterpriseIdTypeConfigurationProvider;
import org.neo4j.kernel.impl.enterprise.transaction.log.checkpoint.ConfigurableIOLimiter;
import org.neo4j.kernel.impl.factory.CommunityEditionModule;
import org.neo4j.kernel.impl.factory.PlatformModule;
import org.neo4j.kernel.impl.factory.StatementLocksFactorySelector;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.StatementLocksFactory;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.proc.Procedures;
import org.neo4j.kernel.impl.store.id.configuration.IdTypeConfigurationProvider;
import org.neo4j.kernel.impl.store.stats.IdBasedStoreEntityCounters;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.logging.Log;

public class EnterpriseEditionModule
extends CommunityEditionModule {
    public void registerEditionSpecificProcedures(Procedures procedures) throws KernelException {
        procedures.registerProcedure(EnterpriseBuiltInDbmsProcedures.class, true);
    }

    public EnterpriseEditionModule(PlatformModule platformModule) {
        super(platformModule);
        platformModule.dependencies.satisfyDependency((Object)new IdBasedStoreEntityCounters(this.idGeneratorFactory));
        this.ioLimiter = new ConfigurableIOLimiter(platformModule.config);
        platformModule.dependencies.satisfyDependency((Object)this.createSessionTracker());
    }

    protected IdTypeConfigurationProvider createIdTypeConfigurationProvider(Config config) {
        return new EnterpriseIdTypeConfigurationProvider(config);
    }

    protected ConstraintSemantics createSchemaRuleVerifier() {
        return new EnterpriseConstraintSemantics();
    }

    protected BoltConnectionTracker createSessionTracker() {
        return new StandardBoltConnectionTracker();
    }

    protected StatementLocksFactory createStatementLocksFactory(Locks locks, Config config, LogService logService) {
        return new StatementLocksFactorySelector(locks, config, logService).select();
    }

    public void setupSecurityModule(PlatformModule platformModule, Procedures procedures) {
        EnterpriseEditionModule.setupEnterpriseSecurityModule(platformModule, procedures);
    }

    public static void setupEnterpriseSecurityModule(PlatformModule platformModule, Procedures procedures) {
        if (((Boolean)platformModule.config.get(GraphDatabaseSettings.auth_enabled)).booleanValue()) {
            EnterpriseEditionModule.setupSecurityModule((PlatformModule)platformModule, (Log)platformModule.logging.getUserLog(EnterpriseEditionModule.class), (Procedures)procedures, (String)((String)platformModule.config.get(EnterpriseEditionSettings.security_module)));
        } else {
            platformModule.life.add((Lifecycle)platformModule.dependencies.satisfyDependency((Object)EnterpriseAuthManager.NO_AUTH));
        }
    }
}

