/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.enterprise.lock.forseti;

import org.neo4j.kernel.impl.enterprise.lock.forseti.ForsetiClient;
import org.neo4j.kernel.impl.enterprise.lock.forseti.ForsetiLockManager;
import org.neo4j.kernel.impl.util.collection.SimpleBitSet;

class ExclusiveLock
implements ForsetiLockManager.Lock {
    private final ForsetiClient owner;

    public ExclusiveLock(ForsetiClient owner) {
        this.owner = owner;
    }

    @Override
    public void copyHolderWaitListsInto(SimpleBitSet waitList) {
        this.owner.copyWaitListTo(waitList);
    }

    @Override
    public int detectDeadlock(int client) {
        return this.owner.isWaitingFor(client) ? this.owner.id() : -1;
    }

    @Override
    public String describeWaitList() {
        return "ExclusiveLock[" + this.owner.describeWaitList() + "]";
    }

    public String toString() {
        return "ExclusiveLock{owner=" + this.owner + '}';
    }
}

