/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.enterprise.lock.forseti;

import java.util.concurrent.ConcurrentMap;
import java.util.function.IntFunction;
import org.neo4j.collection.pool.Pool;
import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.PrimitiveIntIterator;
import org.neo4j.collection.primitive.PrimitiveLongIntMap;
import org.neo4j.collection.primitive.PrimitiveLongVisitor;
import org.neo4j.kernel.DeadlockDetectedException;
import org.neo4j.kernel.impl.enterprise.lock.forseti.ExclusiveLock;
import org.neo4j.kernel.impl.enterprise.lock.forseti.ForsetiLockManager;
import org.neo4j.kernel.impl.enterprise.lock.forseti.SharedLock;
import org.neo4j.kernel.impl.locking.LockClientStateHolder;
import org.neo4j.kernel.impl.locking.LockClientStoppedException;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.util.collection.SimpleBitSet;
import org.neo4j.storageengine.api.lock.AcquireLockTimeoutException;
import org.neo4j.storageengine.api.lock.ResourceType;
import org.neo4j.storageengine.api.lock.WaitStrategy;
import org.neo4j.unsafe.impl.internal.dragons.UnsafeUtil;

public class ForsetiClient
implements Locks.Client {
    private final int clientId;
    private final ConcurrentMap<Long, ForsetiLockManager.Lock>[] lockMaps;
    private final WaitStrategy<AcquireLockTimeoutException>[] waitStrategies;
    private final ForsetiLockManager.DeadlockResolutionStrategy deadlockResolutionStrategy;
    private final Pool<ForsetiClient> clientPool;
    private final IntFunction<ForsetiClient> clientById;
    private final PrimitiveLongIntMap[] sharedLockCounts;
    private final PrimitiveLongIntMap[] exclusiveLockCounts;
    private final SimpleBitSet waitList = new SimpleBitSet(64);
    private final LockClientStateHolder stateHolder = new LockClientStateHolder();
    private final ExclusiveLock myExclusiveLock = new ExclusiveLock(this);
    private volatile boolean hasLocks;
    private final ReleaseExclusiveLocksAndClearSharedVisitor releaseExclusiveAndClearSharedVisitor = new ReleaseExclusiveLocksAndClearSharedVisitor();
    private final ReleaseSharedDontCheckExclusiveVisitor releaseSharedDontCheckExclusiveVisitor = new ReleaseSharedDontCheckExclusiveVisitor();

    public ForsetiClient(int id, ConcurrentMap<Long, ForsetiLockManager.Lock>[] lockMaps, WaitStrategy<AcquireLockTimeoutException>[] waitStrategies, Pool<ForsetiClient> clientPool, ForsetiLockManager.DeadlockResolutionStrategy deadlockResolutionStrategy, IntFunction<ForsetiClient> clientById) {
        this.clientId = id;
        this.lockMaps = lockMaps;
        this.waitStrategies = waitStrategies;
        this.deadlockResolutionStrategy = deadlockResolutionStrategy;
        this.clientPool = clientPool;
        this.clientById = clientById;
        this.sharedLockCounts = new PrimitiveLongIntMap[lockMaps.length];
        this.exclusiveLockCounts = new PrimitiveLongIntMap[lockMaps.length];
        for (int i = 0; i < this.sharedLockCounts.length; ++i) {
            this.sharedLockCounts[i] = Primitive.longIntMap();
            this.exclusiveLockCounts[i] = Primitive.longIntMap();
        }
    }

    public void reset() {
        this.stateHolder.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquireShared(ResourceType resourceType, long ... resourceIds) throws AcquireLockTimeoutException {
        this.hasLocks = true;
        this.stateHolder.incrementActiveClients((Locks.Client)this);
        try {
            ConcurrentMap<Long, ForsetiLockManager.Lock> lockMap = this.lockMaps[resourceType.typeId()];
            PrimitiveLongIntMap heldShareLocks = this.sharedLockCounts[resourceType.typeId()];
            PrimitiveLongIntMap heldExclusiveLocks = this.exclusiveLockCounts[resourceType.typeId()];
            for (long resourceId : resourceIds) {
                int heldCount = heldShareLocks.get(resourceId);
                if (heldCount != -1) {
                    heldShareLocks.put(resourceId, Math.incrementExact(heldCount));
                    continue;
                }
                if (heldExclusiveLocks.containsKey(resourceId)) {
                    heldShareLocks.put(resourceId, 1);
                    continue;
                }
                int tries = 0;
                SharedLock mySharedLock = null;
                while (true) {
                    this.assertNotStopped();
                    ForsetiLockManager.Lock existingLock = (ForsetiLockManager.Lock)lockMap.get(resourceId);
                    if (existingLock == null) {
                        if (mySharedLock == null) {
                            mySharedLock = new SharedLock(this);
                        }
                        if (lockMap.putIfAbsent(resourceId, mySharedLock) != null) continue;
                        break;
                    }
                    if (existingLock instanceof SharedLock) {
                        if (((SharedLock)existingLock).acquire(this)) {
                            break;
                        }
                    } else if (!(existingLock instanceof ExclusiveLock)) {
                        throw new UnsupportedOperationException("Unknown lock type: " + existingLock);
                    }
                    this.applyWaitStrategy(resourceType, tries++);
                    this.markAsWaitingFor(existingLock, resourceType, resourceId);
                }
                this.clearWaitList();
                heldShareLocks.put(resourceId, 1);
            }
        }
        finally {
            this.stateHolder.decrementActiveClients();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquireExclusive(ResourceType resourceType, long ... resourceIds) throws AcquireLockTimeoutException {
        this.hasLocks = true;
        this.stateHolder.incrementActiveClients((Locks.Client)this);
        try {
            ConcurrentMap<Long, ForsetiLockManager.Lock> lockMap = this.lockMaps[resourceType.typeId()];
            PrimitiveLongIntMap heldLocks = this.exclusiveLockCounts[resourceType.typeId()];
            for (long resourceId : resourceIds) {
                ForsetiLockManager.Lock existingLock;
                int heldCount = heldLocks.get(resourceId);
                if (heldCount != -1) {
                    heldLocks.put(resourceId, Math.incrementExact(heldCount));
                    continue;
                }
                int tries = 0;
                while ((existingLock = lockMap.putIfAbsent(resourceId, this.myExclusiveLock)) != null) {
                    SharedLock sharedLock;
                    this.assertNotStopped();
                    if (tries > 50 && existingLock instanceof SharedLock && this.tryUpgradeSharedToExclusive(resourceType, lockMap, resourceId, sharedLock = (SharedLock)existingLock)) break;
                    this.applyWaitStrategy(resourceType, tries++);
                    this.markAsWaitingFor(existingLock, resourceType, resourceId);
                }
                this.clearWaitList();
                heldLocks.put(resourceId, 1);
            }
        }
        finally {
            this.stateHolder.decrementActiveClients();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryExclusiveLock(ResourceType resourceType, long resourceId) {
        this.hasLocks = true;
        this.stateHolder.incrementActiveClients((Locks.Client)this);
        try {
            ConcurrentMap<Long, ForsetiLockManager.Lock> lockMap = this.lockMaps[resourceType.typeId()];
            PrimitiveLongIntMap heldLocks = this.exclusiveLockCounts[resourceType.typeId()];
            int heldCount = heldLocks.get(resourceId);
            if (heldCount != -1) {
                heldLocks.put(resourceId, Math.incrementExact(heldCount));
                boolean bl = true;
                return bl;
            }
            ForsetiLockManager.Lock lock = lockMap.putIfAbsent(resourceId, this.myExclusiveLock);
            if (lock != null) {
                SharedLock sharedLock;
                if (lock instanceof SharedLock && this.sharedLockCounts[resourceType.typeId()].containsKey(resourceId) && (sharedLock = (SharedLock)lock).tryAcquireUpdateLock(this)) {
                    if (sharedLock.numberOfHolders() == 1) {
                        heldLocks.put(resourceId, 1);
                        boolean bl = true;
                        return bl;
                    }
                    sharedLock.releaseUpdateLock(this);
                    boolean bl = false;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            heldLocks.put(resourceId, 1);
            boolean bl = true;
            return bl;
        }
        finally {
            this.stateHolder.decrementActiveClients();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean trySharedLock(ResourceType resourceType, long resourceId) {
        this.hasLocks = true;
        this.stateHolder.incrementActiveClients((Locks.Client)this);
        try {
            PrimitiveLongIntMap heldShareLocks;
            block12: {
                ConcurrentMap<Long, ForsetiLockManager.Lock> lockMap = this.lockMaps[resourceType.typeId()];
                heldShareLocks = this.sharedLockCounts[resourceType.typeId()];
                PrimitiveLongIntMap heldExclusiveLocks = this.exclusiveLockCounts[resourceType.typeId()];
                int heldCount = heldShareLocks.get(resourceId);
                if (heldCount != -1) {
                    heldShareLocks.put(resourceId, Math.incrementExact(heldCount));
                    boolean bl = true;
                    return bl;
                }
                if (heldExclusiveLocks.containsKey(resourceId)) {
                    heldShareLocks.put(resourceId, 1);
                    boolean bl = true;
                    return bl;
                }
                while (true) {
                    this.assertNotStopped();
                    ForsetiLockManager.Lock existingLock = (ForsetiLockManager.Lock)lockMap.get(resourceId);
                    if (existingLock == null) {
                        if (lockMap.putIfAbsent(resourceId, new SharedLock(this)) != null) continue;
                        break block12;
                    }
                    if (!(existingLock instanceof SharedLock)) {
                        if (!(existingLock instanceof ExclusiveLock)) throw new UnsupportedOperationException("Unknown lock type: " + existingLock);
                        boolean bl = false;
                        return bl;
                    }
                    if (((SharedLock)existingLock).acquire(this)) break block12;
                    if (((SharedLock)existingLock).isUpdateLock()) break;
                }
                boolean bl = false;
                return bl;
            }
            heldShareLocks.put(resourceId, 1);
            boolean bl = true;
            return bl;
        }
        finally {
            this.stateHolder.decrementActiveClients();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseShared(ResourceType resourceType, long resourceId) {
        this.stateHolder.incrementActiveClients((Locks.Client)this);
        try {
            if (this.releaseLocalLock(resourceType, resourceId, this.sharedLockCounts[resourceType.typeId()])) {
                return;
            }
            if (!this.exclusiveLockCounts[resourceType.typeId()].containsKey(resourceId)) {
                this.releaseGlobalLock(this.lockMaps[resourceType.typeId()], resourceId);
            }
        }
        finally {
            this.stateHolder.decrementActiveClients();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void releaseExclusive(ResourceType resourceType, long resourceId) {
        this.stateHolder.incrementActiveClients((Locks.Client)this);
        try {
            if (this.releaseLocalLock(resourceType, resourceId, this.exclusiveLockCounts[resourceType.typeId()])) {
                return;
            }
            ConcurrentMap<Long, ForsetiLockManager.Lock> lockMap = this.lockMaps[resourceType.typeId()];
            if (this.sharedLockCounts[resourceType.typeId()].containsKey(resourceId)) {
                ForsetiLockManager.Lock lock = (ForsetiLockManager.Lock)lockMap.get(resourceId);
                if (lock instanceof SharedLock) {
                    SharedLock sharedLock = (SharedLock)lock;
                    if (!sharedLock.isUpdateLock()) throw new IllegalStateException("Incorrect state of exclusive lock. Lock should be updated to exclusive before attempt to release it. Lock: " + this);
                    sharedLock.releaseUpdateLock(this);
                    return;
                } else {
                    SharedLock sharedLock = new SharedLock(this);
                    lockMap.put(resourceId, sharedLock);
                }
                return;
            } else {
                this.releaseGlobalLock(lockMap, resourceId);
            }
            return;
        }
        finally {
            this.stateHolder.decrementActiveClients();
        }
    }

    private void releaseAllClientLocks() {
        for (int i = 0; i < this.exclusiveLockCounts.length; ++i) {
            int size;
            PrimitiveLongIntMap exclusiveLocks = this.exclusiveLockCounts[i];
            PrimitiveLongIntMap sharedLocks = this.sharedLockCounts[i];
            if (exclusiveLocks != null) {
                size = exclusiveLocks.size();
                exclusiveLocks.visitKeys(this.releaseExclusiveAndClearSharedVisitor.initialize(sharedLocks, this.lockMaps[i]));
                if (size <= 32) {
                    if (size > 0) {
                        exclusiveLocks.clear();
                    }
                } else {
                    this.exclusiveLockCounts[i] = Primitive.longIntMap();
                }
            }
            if (sharedLocks == null) continue;
            size = sharedLocks.size();
            sharedLocks.visitKeys(this.releaseSharedDontCheckExclusiveVisitor.initialize(this.lockMaps[i]));
            if (size <= 32) {
                if (size <= 0) continue;
                sharedLocks.clear();
                continue;
            }
            this.sharedLockCounts[i] = Primitive.longIntMap();
        }
    }

    public void stop() {
        this.stateHolder.stopClient();
        while (this.stateHolder.hasActiveClients()) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                Thread.interrupted();
            }
        }
    }

    public void close() {
        this.stop();
        if (this.hasLocks) {
            this.releaseAllClientLocks();
            this.clearWaitList();
            this.hasLocks = false;
        }
        this.clientPool.release((Object)this);
    }

    public int getLockSessionId() {
        return this.clientId;
    }

    public int waitListSize() {
        return this.waitList.size();
    }

    public void copyWaitListTo(SimpleBitSet other) {
        other.put(this.waitList);
    }

    public boolean isWaitingFor(int clientId) {
        return clientId != this.clientId && this.waitList.contains(clientId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ForsetiClient that = (ForsetiClient)o;
        return this.clientId == that.clientId;
    }

    public int hashCode() {
        return this.clientId;
    }

    public String toString() {
        return String.format("ForsetiClient[%d]", this.clientId);
    }

    private void releaseGlobalLock(ConcurrentMap<Long, ForsetiLockManager.Lock> lockMap, long resourceId) {
        ForsetiLockManager.Lock lock = (ForsetiLockManager.Lock)lockMap.get(resourceId);
        if (lock instanceof ExclusiveLock) {
            lockMap.remove(resourceId);
        } else if (lock instanceof SharedLock && ((SharedLock)lock).release(this)) {
            ((SharedLock)lock).cleanUpdateHolder();
            lockMap.remove(resourceId);
        }
    }

    private boolean releaseLocalLock(ResourceType type, long resourceId, PrimitiveLongIntMap localLocks) {
        int lockCount = localLocks.remove(resourceId);
        if (lockCount == -1) {
            throw new IllegalStateException(this + " cannot release lock that it does not hold: " + type + "[" + resourceId + "].");
        }
        if (lockCount > 1) {
            localLocks.put(resourceId, lockCount - 1);
            return true;
        }
        return false;
    }

    private boolean tryUpgradeSharedToExclusive(ResourceType resourceType, ConcurrentMap<Long, ForsetiLockManager.Lock> lockMap, long resourceId, SharedLock sharedLock) throws AcquireLockTimeoutException {
        int tries = 0;
        boolean holdsSharedLock = this.sharedLockCounts[resourceType.typeId()].containsKey(resourceId);
        if (!holdsSharedLock) {
            if (!sharedLock.acquire(this)) {
                return false;
            }
            try {
                if (this.tryUpgradeToExclusiveWithShareLockHeld(resourceType, resourceId, sharedLock, tries)) {
                    return true;
                }
                this.releaseGlobalLock(lockMap, resourceId);
                return false;
            }
            catch (Throwable e) {
                this.releaseGlobalLock(lockMap, resourceId);
                throw e;
            }
        }
        return this.tryUpgradeToExclusiveWithShareLockHeld(resourceType, resourceId, sharedLock, tries);
    }

    private boolean tryUpgradeToExclusiveWithShareLockHeld(ResourceType resourceType, long resourceId, SharedLock sharedLock, int tries) throws AcquireLockTimeoutException {
        if (sharedLock.tryAcquireUpdateLock(this)) {
            try {
                while (sharedLock.numberOfHolders() > 1) {
                    this.applyWaitStrategy(resourceType, tries++);
                    this.markAsWaitingFor(sharedLock, resourceType, resourceId);
                }
                return true;
            }
            catch (DeadlockDetectedException e) {
                sharedLock.releaseUpdateLock(this);
                throw e;
            }
            catch (LockClientStoppedException e) {
                this.handleUpgradeToExclusiveFailure(sharedLock);
                throw e;
            }
            catch (Throwable e) {
                this.handleUpgradeToExclusiveFailure(sharedLock);
                throw new RuntimeException(e);
            }
        }
        return false;
    }

    private void handleUpgradeToExclusiveFailure(SharedLock sharedLock) {
        sharedLock.releaseUpdateLock(this);
        this.clearWaitList();
    }

    private void clearWaitList() {
        this.waitList.clear();
        this.waitList.put(this.clientId);
    }

    private void markAsWaitingFor(ForsetiLockManager.Lock lock, ResourceType type, long resourceId) {
        this.clearWaitList();
        lock.copyHolderWaitListsInto(this.waitList);
        int b = lock.detectDeadlock(this.id());
        if (b != -1 && this.deadlockResolutionStrategy.shouldAbort(this, this.clientById.apply(b))) {
            UnsafeUtil.loadFence();
            String message = this + " can't acquire " + lock + " on " + type + "(" + resourceId + "), because holders of that lock are waiting for " + this + ".\n Wait list:" + lock.describeWaitList();
            if (lock.detectDeadlock(this.id()) != -1) {
                this.waitList.clear();
                throw new DeadlockDetectedException(message);
            }
        }
    }

    public int lockCount() {
        int count = 0;
        for (PrimitiveLongIntMap sharedLockCount : this.sharedLockCounts) {
            count += sharedLockCount.size();
        }
        for (PrimitiveLongIntMap exclusiveLockCount : this.exclusiveLockCounts) {
            count += exclusiveLockCount.size();
        }
        return count;
    }

    public String describeWaitList() {
        StringBuilder sb = new StringBuilder(String.format("%nClient[%d] waits for [", this.id()));
        PrimitiveIntIterator iter = this.waitList.iterator();
        boolean first = true;
        while (iter.hasNext()) {
            int next = iter.next();
            if (next == this.clientId) continue;
            sb.append(!first ? "," : "").append(next);
            first = false;
        }
        sb.append("]");
        return sb.toString();
    }

    public int id() {
        return this.clientId;
    }

    private void applyWaitStrategy(ResourceType resourceType, int tries) {
        WaitStrategy<AcquireLockTimeoutException> waitStrategy = this.waitStrategies[resourceType.typeId()];
        waitStrategy.apply((long)tries);
        this.assertNotStopped();
    }

    private void assertNotStopped() {
        if (this.stateHolder.isStopped()) {
            throw new LockClientStoppedException((Locks.Client)this);
        }
    }

    private class ReleaseExclusiveLocksAndClearSharedVisitor
    implements PrimitiveLongVisitor<RuntimeException> {
        private PrimitiveLongIntMap sharedLockCounts;
        private ConcurrentMap<Long, ForsetiLockManager.Lock> lockMap;

        private ReleaseExclusiveLocksAndClearSharedVisitor() {
        }

        private PrimitiveLongVisitor<RuntimeException> initialize(PrimitiveLongIntMap sharedLockCounts, ConcurrentMap<Long, ForsetiLockManager.Lock> lockMap) {
            this.sharedLockCounts = sharedLockCounts;
            this.lockMap = lockMap;
            return this;
        }

        public boolean visited(long resourceId) {
            ForsetiClient.this.releaseGlobalLock(this.lockMap, resourceId);
            if (this.sharedLockCounts != null) {
                this.sharedLockCounts.remove(resourceId);
            }
            return false;
        }
    }

    private class ReleaseSharedDontCheckExclusiveVisitor
    implements PrimitiveLongVisitor<RuntimeException> {
        private ConcurrentMap<Long, ForsetiLockManager.Lock> lockMap;

        private ReleaseSharedDontCheckExclusiveVisitor() {
        }

        private PrimitiveLongVisitor<RuntimeException> initialize(ConcurrentMap<Long, ForsetiLockManager.Lock> lockMap) {
            this.lockMap = lockMap;
            return this;
        }

        public boolean visited(long resourceId) {
            ForsetiClient.this.releaseGlobalLock(this.lockMap, resourceId);
            return false;
        }
    }
}

