/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.enterprise.transaction.log.checkpoint;

import java.io.Flushable;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.locks.LockSupport;
import java.util.function.ObjLongConsumer;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.kernel.configuration.Config;

public class ConfigurableIOLimiter
implements IOLimiter {
    private static final AtomicIntegerFieldUpdater<ConfigurableIOLimiter> disableCountUpdater = AtomicIntegerFieldUpdater.newUpdater(ConfigurableIOLimiter.class, "disabledCount");
    private static final int NO_LIMIT = 0;
    private static final int QUANTUM_MILLIS = 100;
    private static final int TIME_BITS = 32;
    private static final long TIME_MASK = 0xFFFFFFFFL;
    private final int iopq;
    private final ObjLongConsumer<Object> pauseNanos;
    private volatile int disabledCount;

    public ConfigurableIOLimiter(Config config) {
        this(config, LockSupport::parkNanos);
    }

    ConfigurableIOLimiter(Config config, ObjLongConsumer<Object> pauseNanos) {
        this.pauseNanos = pauseNanos;
        int quantumsPerSecond = (int)(TimeUnit.SECONDS.toMillis(1L) / 100L);
        Integer iops = (Integer)config.get(GraphDatabaseSettings.check_point_iops_limit);
        if (iops == null || iops < 1) {
            this.iopq = 0;
            this.disabledCount = 1;
        } else {
            this.iopq = iops / quantumsPerSecond;
        }
    }

    public long maybeLimitIO(long previousStamp, int recentlyCompletedIOs, Flushable flushable) throws IOException {
        long then;
        if (this.disabledCount > 0) {
            return 0L;
        }
        long now = this.currentTimeMillis() & 0xFFFFFFFFL;
        if (now - (then = previousStamp & 0xFFFFFFFFL) > 100L) {
            return now + ((long)recentlyCompletedIOs << 32);
        }
        long ioSum = (previousStamp >> 32) + (long)recentlyCompletedIOs;
        if (ioSum >= (long)this.iopq) {
            long millisLeftInQuantum = 100L - (now - then);
            this.pauseNanos.accept(this, TimeUnit.MILLISECONDS.toNanos(millisLeftInQuantum));
            return this.currentTimeMillis() & 0xFFFFFFFFL;
        }
        return then + (ioSum << 32);
    }

    public void disableLimit() {
        disableCountUpdater.getAndIncrement(this);
    }

    public void enableLimit() {
        disableCountUpdater.getAndDecrement(this);
    }

    private long currentTimeMillis() {
        return System.currentTimeMillis();
    }
}

