/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.format.highlimit;

import java.io.IOException;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.impl.store.format.BaseRecordFormat;
import org.neo4j.kernel.impl.store.format.highlimit.BaseHighLimitRecordFormat;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.Record;

class NodeRecordFormat
extends BaseHighLimitRecordFormat<NodeRecord> {
    static final int RECORD_SIZE = 16;
    static final int FIXED_FORMAT_RECORD_SIZE = 15;
    private static final long NULL_LABELS = Record.NO_LABELS_FIELD.intValue();
    private static final int DENSE_NODE_BIT = 8;
    private static final int HAS_RELATIONSHIP_BIT = 16;
    private static final int HAS_PROPERTY_BIT = 32;
    private static final int HAS_LABELS_BIT = 64;
    private static final long HIGH_DWORD_LOWER_NIBBLE_CHECK_MASK = 0xF00000000L;
    private static final long HIGH_DWORD_LOWER_NIBBLE_MASK = -68719476736L;
    private static final long LOWER_NIBBLE_READ_MASK = 15L;
    private static final long HIGHER_NIBBLE_READ_MASK = 240L;

    public NodeRecordFormat() {
        this(16);
    }

    NodeRecordFormat(int recordSize) {
        super(NodeRecordFormat.fixedRecordSize((int)recordSize), 0);
    }

    public NodeRecord newRecord() {
        return new NodeRecord(-1L);
    }

    @Override
    protected void doReadInternal(NodeRecord record, PageCursor cursor, int recordSize, long headerByte, boolean inUse) {
        boolean dense = NodeRecordFormat.has((long)headerByte, (int)8);
        if (record.isUseFixedReferences()) {
            this.readFixedReferencesRecord(record, cursor, inUse, dense);
            record.setUseFixedReferences(true);
        } else {
            long nextRel = NodeRecordFormat.decodeCompressedReference(cursor, headerByte, 16, NULL);
            long nextProp = NodeRecordFormat.decodeCompressedReference(cursor, headerByte, 32, NULL);
            long labelField = NodeRecordFormat.decodeCompressedReference(cursor, headerByte, 64, NULL_LABELS);
            record.initialize(inUse, nextProp, dense, nextRel, labelField);
        }
    }

    @Override
    public int requiredDataLength(NodeRecord record) {
        return NodeRecordFormat.length(record.getNextRel(), NULL) + NodeRecordFormat.length(record.getNextProp(), NULL) + NodeRecordFormat.length(record.getLabelField(), NULL_LABELS);
    }

    @Override
    protected byte headerBits(NodeRecord record) {
        byte header = 0;
        header = NodeRecordFormat.set((byte)header, (int)8, (boolean)record.isDense());
        header = NodeRecordFormat.set(header, 16, record.getNextRel(), NULL);
        header = NodeRecordFormat.set(header, 32, record.getNextProp(), NULL);
        header = NodeRecordFormat.set(header, 64, record.getLabelField(), NULL_LABELS);
        return header;
    }

    @Override
    protected boolean canUseFixedReferences(NodeRecord record, int recordSize) {
        return !(!this.isRecordBigEnoughForFixedReferences(recordSize) || record.getNextProp() != NULL && (record.getNextProp() & 0xFFFFFFF000000000L) != 0L || record.getNextRel() != NULL && (record.getNextRel() & 0xFFFFFFF000000000L) != 0L);
    }

    private boolean isRecordBigEnoughForFixedReferences(int recordSize) {
        return 15 <= recordSize;
    }

    @Override
    protected void doWriteInternal(NodeRecord record, PageCursor cursor) throws IOException {
        if (record.isUseFixedReferences()) {
            this.writeFixedReferencesRecord(record, cursor);
        } else {
            NodeRecordFormat.encode(cursor, record.getNextRel(), NULL);
            NodeRecordFormat.encode(cursor, record.getNextProp(), NULL);
            NodeRecordFormat.encode(cursor, record.getLabelField(), NULL_LABELS);
        }
    }

    private void readFixedReferencesRecord(NodeRecord record, PageCursor cursor, boolean inUse, boolean dense) {
        byte modifiers = cursor.getByte();
        long relModifier = ((long)modifiers & 0xFL) << 32;
        long propModifier = ((long)modifiers & 0xF0L) << 28;
        long nextRel = (long)cursor.getInt() & 0xFFFFFFFFL;
        long nextProp = (long)cursor.getInt() & 0xFFFFFFFFL;
        long lsbLabels = (long)cursor.getInt() & 0xFFFFFFFFL;
        long hsbLabels = cursor.getByte() & 0xFF;
        long labels = lsbLabels | hsbLabels << 32;
        record.initialize(inUse, BaseRecordFormat.longFromIntAndMod((long)nextProp, (long)propModifier), dense, BaseRecordFormat.longFromIntAndMod((long)nextRel, (long)relModifier), labels);
    }

    private void writeFixedReferencesRecord(NodeRecord record, PageCursor cursor) {
        long nextRel = record.getNextRel();
        long nextProp = record.getNextProp();
        short relModifier = nextRel == NULL ? (short)0 : (short)((nextRel & 0xF00000000L) >> 32);
        short propModifier = nextProp == NULL ? (short)0 : (short)((nextProp & 0xF00000000L) >> 28);
        short modifiers = (short)(relModifier | propModifier);
        cursor.putByte((byte)modifiers);
        cursor.putInt((int)nextRel);
        cursor.putInt((int)nextProp);
        long labelField = record.getLabelField();
        cursor.putInt((int)labelField);
        cursor.putByte((byte)((labelField & 0xFF00000000L) >> 32));
    }
}

