/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.format.highlimit.v300;

import java.io.IOException;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.impl.store.format.BaseOneByteHeaderRecordFormat;
import org.neo4j.kernel.impl.store.format.highlimit.Reference;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;

public class PropertyRecordFormatV3_0_0
extends BaseOneByteHeaderRecordFormat<PropertyRecord> {
    public static final int RECORD_SIZE = 48;

    public PropertyRecordFormatV3_0_0() {
        super(PropertyRecordFormatV3_0_0.fixedRecordSize((int)48), 0, 1, 50);
    }

    public PropertyRecord newRecord() {
        return new PropertyRecord(-1L);
    }

    public void read(PropertyRecord record, PageCursor cursor, RecordLoad mode, int recordSize) throws IOException {
        int offset = cursor.getOffset();
        byte headerByte = cursor.getByte();
        boolean inUse = this.isInUse(headerByte);
        if (mode.shouldLoad(inUse)) {
            int blockCount = headerByte >>> 4;
            long recordId = record.getId();
            record.initialize(inUse, Reference.toAbsolute(Reference.decode(cursor), recordId), Reference.toAbsolute(Reference.decode(cursor), recordId));
            if (blockCount > record.getBlockCapacity() | 48 - (cursor.getOffset() - offset) < blockCount * 8) {
                cursor.setCursorException("PropertyRecord claims to contain more blocks than can fit in a record");
                return;
            }
            while (blockCount-- > 0) {
                record.addLoadedBlock(cursor.getLong());
            }
        }
    }

    public void write(PropertyRecord record, PageCursor cursor, int recordSize) throws IOException {
        if (record.inUse()) {
            cursor.putByte((byte)((record.inUse() ? 1 : 0) | this.numberOfBlocks(record) << 4));
            long recordId = record.getId();
            Reference.encode(Reference.toRelative(record.getPrevProp(), recordId), cursor);
            Reference.encode(Reference.toRelative(record.getNextProp(), recordId), cursor);
            for (PropertyBlock block : record) {
                for (long propertyBlock : block.getValueBlocks()) {
                    cursor.putLong(propertyBlock);
                }
            }
        } else {
            this.markAsUnused(cursor);
        }
    }

    private int numberOfBlocks(PropertyRecord record) {
        int count = 0;
        for (PropertyBlock block : record) {
            count += block.getValueBlocks().length;
        }
        return count;
    }

    public long getNextRecordReference(PropertyRecord record) {
        return record.getNextProp();
    }
}

