/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.format.highlimit.v306;

import java.io.IOException;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.impl.store.format.BaseOneByteHeaderRecordFormat;
import org.neo4j.kernel.impl.store.format.highlimit.Reference;
import org.neo4j.kernel.impl.store.format.highlimit.v306.BaseHighLimitRecordFormatV3_0_6;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;

class PropertyRecordFormatV3_0_6
extends BaseOneByteHeaderRecordFormat<PropertyRecord> {
    static final int RECORD_SIZE = 48;
    private static final int PROPERTY_BLOCKS_PADDING = 3;
    static final int FIXED_FORMAT_RECORD_SIZE = 16;
    private static final long HIGH_DWORD_LOWER_WORD_MASK = 0xFFFF00000000L;
    private static final long HIGH_DWORD_LOWER_WORD_CHECK_MASK = -281474976710656L;

    protected PropertyRecordFormatV3_0_6() {
        super(PropertyRecordFormatV3_0_6.fixedRecordSize((int)48), 0, 1, 50);
    }

    public PropertyRecord newRecord() {
        return new PropertyRecord(-1L);
    }

    public void read(PropertyRecord record, PageCursor cursor, RecordLoad mode, int recordSize) throws IOException {
        int offset = cursor.getOffset();
        byte headerByte = cursor.getByte();
        boolean inUse = this.isInUse(headerByte);
        boolean useFixedReferences = PropertyRecordFormatV3_0_6.has((long)headerByte, (int)4);
        if (mode.shouldLoad(inUse)) {
            int blockCount = headerByte >>> 4;
            long recordId = record.getId();
            if (useFixedReferences) {
                this.readFixedReferencesRecord(record, cursor);
            } else {
                record.initialize(inUse, Reference.toAbsolute(Reference.decode(cursor), recordId), Reference.toAbsolute(Reference.decode(cursor), recordId));
            }
            record.setUseFixedReferences(useFixedReferences);
            if (blockCount > record.getBlockCapacity() | 48 - (cursor.getOffset() - offset) < blockCount * 8) {
                cursor.setCursorException("PropertyRecord claims to contain more blocks than can fit in a record");
                return;
            }
            while (blockCount-- > 0) {
                record.addLoadedBlock(cursor.getLong());
            }
        }
    }

    public void write(PropertyRecord record, PageCursor cursor, int recordSize) throws IOException {
        if (record.inUse()) {
            byte headerByte = (byte)((record.inUse() ? 1 : 0) | this.numberOfBlocks(record) << 4);
            boolean canUseFixedReferences = this.canUseFixedReferences(record, recordSize);
            record.setUseFixedReferences(canUseFixedReferences);
            headerByte = PropertyRecordFormatV3_0_6.set((byte)headerByte, (int)4, (boolean)canUseFixedReferences);
            cursor.putByte(headerByte);
            long recordId = record.getId();
            if (canUseFixedReferences) {
                this.writeFixedReferencesRecord(record, cursor);
            } else {
                Reference.encode(Reference.toRelative(record.getPrevProp(), recordId), cursor);
                Reference.encode(Reference.toRelative(record.getNextProp(), recordId), cursor);
            }
            for (PropertyBlock block : record) {
                for (long propertyBlock : block.getValueBlocks()) {
                    cursor.putLong(propertyBlock);
                }
            }
        } else {
            this.markAsUnused(cursor);
        }
    }

    private int numberOfBlocks(PropertyRecord record) {
        int count = 0;
        for (PropertyBlock block : record) {
            count += block.getValueBlocks().length;
        }
        return count;
    }

    public long getNextRecordReference(PropertyRecord record) {
        return record.getNextProp();
    }

    private boolean canUseFixedReferences(PropertyRecord record, int recordSize) {
        return !(!this.isRecordBigEnoughForFixedReferences(recordSize) || record.getNextProp() != BaseHighLimitRecordFormatV3_0_6.NULL && (record.getNextProp() & 0xFFFF000000000000L) != 0L || record.getPrevProp() != BaseHighLimitRecordFormatV3_0_6.NULL && (record.getPrevProp() & 0xFFFF000000000000L) != 0L);
    }

    private boolean isRecordBigEnoughForFixedReferences(int recordSize) {
        return 16 <= recordSize;
    }

    private void readFixedReferencesRecord(PropertyRecord record, PageCursor cursor) {
        long prevMod = (long)cursor.getShort() & 0xFFFFL;
        long prevProp = (long)cursor.getInt() & 0xFFFFFFFFL;
        long nextMod = (long)cursor.getShort() & 0xFFFFL;
        long nextProp = (long)cursor.getInt() & 0xFFFFFFFFL;
        record.initialize(true, BaseHighLimitRecordFormatV3_0_6.longFromIntAndMod((long)prevProp, (long)(prevMod << 32)), BaseHighLimitRecordFormatV3_0_6.longFromIntAndMod((long)nextProp, (long)(nextMod << 32)));
        cursor.setOffset(cursor.getOffset() + 3);
    }

    private void writeFixedReferencesRecord(PropertyRecord record, PageCursor cursor) {
        short prevModifier = record.getPrevProp() == BaseHighLimitRecordFormatV3_0_6.NULL ? (short)0 : (short)((record.getPrevProp() & 0xFFFF00000000L) >> 32);
        short nextModifier = record.getNextProp() == BaseHighLimitRecordFormatV3_0_6.NULL ? (short)0 : (short)((record.getNextProp() & 0xFFFF00000000L) >> 32);
        cursor.putShort(prevModifier);
        cursor.putInt((int)record.getPrevProp());
        cursor.putShort(nextModifier);
        cursor.putInt((int)record.getNextProp());
        cursor.setOffset(cursor.getOffset() + 3);
    }
}

