/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.enterprise;

import java.util.Iterator;
import org.neo4j.cursor.Cursor;
import org.neo4j.kernel.api.constraints.NodePropertyExistenceConstraint;
import org.neo4j.kernel.api.constraints.PropertyConstraint;
import org.neo4j.kernel.api.constraints.RelationshipPropertyExistenceConstraint;
import org.neo4j.kernel.api.exceptions.schema.ConstraintVerificationFailedKernelException;
import org.neo4j.kernel.api.exceptions.schema.CreateConstraintFailureException;
import org.neo4j.kernel.api.exceptions.schema.NodePropertyExistenceConstraintVerificationFailedKernelException;
import org.neo4j.kernel.api.exceptions.schema.RelationshipPropertyExistenceConstraintVerificationFailedKernelException;
import org.neo4j.kernel.impl.constraints.StandardConstraintSemantics;
import org.neo4j.kernel.impl.enterprise.PropertyExistenceEnforcer;
import org.neo4j.kernel.impl.store.record.NodePropertyExistenceConstraintRule;
import org.neo4j.kernel.impl.store.record.PropertyConstraintRule;
import org.neo4j.kernel.impl.store.record.RelationshipPropertyExistenceConstraintRule;
import org.neo4j.storageengine.api.NodeItem;
import org.neo4j.storageengine.api.RelationshipItem;
import org.neo4j.storageengine.api.StoreReadLayer;
import org.neo4j.storageengine.api.txstate.ReadableTransactionState;
import org.neo4j.storageengine.api.txstate.TxStateVisitor;

public class EnterpriseConstraintSemantics
extends StandardConstraintSemantics {
    protected PropertyConstraint readNonStandardConstraint(PropertyConstraintRule rule) {
        if (rule instanceof NodePropertyExistenceConstraintRule) {
            return ((NodePropertyExistenceConstraintRule)rule).toConstraint();
        }
        if (rule instanceof RelationshipPropertyExistenceConstraintRule) {
            return ((RelationshipPropertyExistenceConstraintRule)rule).toConstraint();
        }
        throw new IllegalStateException("Unsupported constraint type: " + rule);
    }

    public PropertyConstraintRule writeNodePropertyExistenceConstraint(long ruleId, int type, int propertyKey) {
        return NodePropertyExistenceConstraintRule.nodePropertyExistenceConstraintRule((long)ruleId, (int)type, (int)propertyKey);
    }

    public PropertyConstraintRule writeRelationshipPropertyExistenceConstraint(long ruleId, int type, int propertyKey) {
        return RelationshipPropertyExistenceConstraintRule.relPropertyExistenceConstraintRule((long)ruleId, (int)type, (int)propertyKey);
    }

    public void validateNodePropertyExistenceConstraint(Cursor<NodeItem> allNodes, int label, int propertyKey) throws CreateConstraintFailureException {
        while (allNodes.next()) {
            NodeItem node = (NodeItem)allNodes.get();
            if (node.hasProperty(propertyKey)) continue;
            throw this.createConstraintFailure((ConstraintVerificationFailedKernelException)new NodePropertyExistenceConstraintVerificationFailedKernelException(new NodePropertyExistenceConstraint(label, propertyKey), node.id()));
        }
    }

    public void validateRelationshipPropertyExistenceConstraint(Cursor<RelationshipItem> allRels, int type, int propertyKey) throws CreateConstraintFailureException {
        while (allRels.next()) {
            RelationshipItem relationship = (RelationshipItem)allRels.get();
            if (relationship.type() != type || relationship.hasProperty(propertyKey)) continue;
            throw this.createConstraintFailure((ConstraintVerificationFailedKernelException)new RelationshipPropertyExistenceConstraintVerificationFailedKernelException(new RelationshipPropertyExistenceConstraint(type, propertyKey), relationship.id()));
        }
    }

    private CreateConstraintFailureException createConstraintFailure(ConstraintVerificationFailedKernelException it) {
        return new CreateConstraintFailureException(it.constraint(), (Throwable)it);
    }

    public TxStateVisitor decorateTxStateVisitor(StoreReadLayer storeLayer, ReadableTransactionState txState, TxStateVisitor visitor) {
        Iterator constraints = storeLayer.constraintsGetAll();
        while (constraints.hasNext()) {
            PropertyConstraint constraint = (PropertyConstraint)constraints.next();
            if (!(constraint instanceof NodePropertyExistenceConstraint) && !(constraint instanceof RelationshipPropertyExistenceConstraint)) continue;
            return new PropertyExistenceEnforcer(visitor, txState, storeLayer);
        }
        return visitor;
    }
}

