/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.enterprise.builtinprocs;

import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.neo4j.kernel.api.exceptions.InvalidArgumentsException;
import org.neo4j.kernel.api.query.ExecutingQuery;
import org.neo4j.kernel.api.query.QuerySnapshot;
import org.neo4j.kernel.enterprise.builtinprocs.QueryId;
import org.neo4j.kernel.impl.query.clientconnection.ClientConnectionInfo;

public class QueryStatusResult {
    public static final ZoneId UTC_ZONE_ID = ZoneId.of("UTC");
    public final String queryId;
    public final String username;
    public final Map<String, Object> metaData;
    public final String query;
    public final Map<String, Object> parameters;
    public final String planner;
    public final String runtime;
    public final List<Map<String, String>> indexes;
    public final String startTime;
    @Deprecated
    public final String elapsedTime;
    @Deprecated
    public final String connectionDetails;
    public final String protocol;
    public final String clientAddress;
    public final String requestUri;
    public final String status;
    public final Map<String, Object> resourceInformation;
    public final long activeLockCount;
    public final long elapsedTimeMillis;
    public final Long cpuTimeMillis;
    public final long waitTimeMillis;
    public final Long idleTimeMillis;
    public final Long allocatedBytes;
    public final long pageHits;
    public final long pageFaults;

    QueryStatusResult(ExecutingQuery query) throws InvalidArgumentsException {
        this(query.snapshot());
    }

    private QueryStatusResult(QuerySnapshot query) throws InvalidArgumentsException {
        this.queryId = QueryId.ofInternalId(query.internalQueryId()).toString();
        this.username = query.username();
        this.query = query.queryText();
        this.parameters = query.queryParameters();
        this.startTime = QueryStatusResult.formatTime(query.startTimestampMillis());
        this.elapsedTimeMillis = query.elapsedTimeMillis();
        this.elapsedTime = QueryStatusResult.formatInterval(this.elapsedTimeMillis);
        ClientConnectionInfo clientConnection = query.clientConnection();
        this.connectionDetails = clientConnection.asConnectionDetails();
        this.protocol = clientConnection.protocol();
        this.clientAddress = clientConnection.clientAddress();
        this.requestUri = clientConnection.requestURI();
        this.metaData = query.transactionAnnotationData();
        this.cpuTimeMillis = query.cpuTimeMillis();
        this.status = query.status();
        this.resourceInformation = query.resourceInformation();
        this.activeLockCount = query.activeLockCount();
        this.waitTimeMillis = query.waitTimeMillis();
        this.idleTimeMillis = query.idleTimeMillis();
        this.planner = query.planner();
        this.runtime = query.runtime();
        this.indexes = query.indexes();
        this.allocatedBytes = query.allocatedBytes();
        this.pageHits = query.pageHits();
        this.pageFaults = query.pageFaults();
    }

    private static String formatTime(long startTime) {
        return OffsetDateTime.ofInstant(Instant.ofEpochMilli(startTime), UTC_ZONE_ID).format(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
    }

    private static String formatInterval(long l) {
        long hr = TimeUnit.MILLISECONDS.toHours(l);
        long min = TimeUnit.MILLISECONDS.toMinutes(l - TimeUnit.HOURS.toMillis(hr));
        long sec = TimeUnit.MILLISECONDS.toSeconds(l - TimeUnit.HOURS.toMillis(hr) - TimeUnit.MINUTES.toMillis(min));
        long ms = l - TimeUnit.HOURS.toMillis(hr) - TimeUnit.MINUTES.toMillis(min) - TimeUnit.SECONDS.toMillis(sec);
        return String.format("%02d:%02d:%02d.%03d", hr, min, sec, ms);
    }
}

