/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.enterprise;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.PrimitiveArrays;
import org.neo4j.collection.primitive.PrimitiveIntObjectMap;
import org.neo4j.collection.primitive.PrimitiveIntSet;
import org.neo4j.cursor.Cursor;
import org.neo4j.kernel.api.AssertOpen;
import org.neo4j.kernel.api.exceptions.schema.ConstraintValidationException;
import org.neo4j.kernel.api.exceptions.schema.NodePropertyExistenceException;
import org.neo4j.kernel.api.exceptions.schema.RelationshipPropertyExistenceException;
import org.neo4j.kernel.api.schema.LabelSchemaDescriptor;
import org.neo4j.kernel.api.schema.RelationTypeSchemaDescriptor;
import org.neo4j.kernel.api.schema.SchemaProcessor;
import org.neo4j.kernel.api.schema.constaints.ConstraintDescriptor;
import org.neo4j.kernel.impl.locking.Lock;
import org.neo4j.storageengine.api.NodeItem;
import org.neo4j.storageengine.api.PropertyItem;
import org.neo4j.storageengine.api.RelationshipItem;
import org.neo4j.storageengine.api.StorageProperty;
import org.neo4j.storageengine.api.StorageStatement;
import org.neo4j.storageengine.api.StoreReadLayer;
import org.neo4j.storageengine.api.txstate.PropertyContainerState;
import org.neo4j.storageengine.api.txstate.ReadableTransactionState;
import org.neo4j.storageengine.api.txstate.TxStateVisitor;

class PropertyExistenceEnforcer {
    private final List<LabelSchemaDescriptor> nodeConstraints;
    private final List<RelationTypeSchemaDescriptor> relationshipConstraints;
    private final PrimitiveIntObjectMap<int[]> mandatoryNodePropertiesByLabel = Primitive.intObjectMap();
    private final PrimitiveIntObjectMap<int[]> mandatoryRelationshipPropertiesByType = Primitive.intObjectMap();
    private static final PropertyExistenceEnforcer NO_CONSTRAINTS = new PropertyExistenceEnforcer(Collections.emptyList(), Collections.emptyList()){

        @Override
        TxStateVisitor decorate(TxStateVisitor visitor, ReadableTransactionState txState, StoreReadLayer storeLayer) {
            return visitor;
        }
    };
    private static final Function<StoreReadLayer, PropertyExistenceEnforcer> FACTORY = storeLayer -> {
        final ArrayList<LabelSchemaDescriptor> nodes = new ArrayList<LabelSchemaDescriptor>();
        final ArrayList<RelationTypeSchemaDescriptor> relationships = new ArrayList<RelationTypeSchemaDescriptor>();
        Iterator constraints = storeLayer.constraintsGetAll();
        while (constraints.hasNext()) {
            ConstraintDescriptor constraint = (ConstraintDescriptor)constraints.next();
            if (!constraint.enforcesPropertyExistence()) continue;
            constraint.schema().processWith(new SchemaProcessor(){

                public void processSpecific(LabelSchemaDescriptor schema) {
                    nodes.add(schema);
                }

                public void processSpecific(RelationTypeSchemaDescriptor schema) {
                    relationships.add(schema);
                }
            });
        }
        if (nodes.isEmpty() && relationships.isEmpty()) {
            return NO_CONSTRAINTS;
        }
        return new PropertyExistenceEnforcer(nodes, relationships);
    };

    static PropertyExistenceEnforcer getOrCreatePropertyExistenceEnforcerFrom(StoreReadLayer storeLayer) {
        return (PropertyExistenceEnforcer)storeLayer.getOrCreateSchemaDependantState(PropertyExistenceEnforcer.class, FACTORY);
    }

    private PropertyExistenceEnforcer(List<LabelSchemaDescriptor> nodes, List<RelationTypeSchemaDescriptor> rels) {
        this.nodeConstraints = nodes;
        this.relationshipConstraints = rels;
        for (LabelSchemaDescriptor labelSchemaDescriptor : nodes) {
            PropertyExistenceEnforcer.update(this.mandatoryNodePropertiesByLabel, labelSchemaDescriptor.getLabelId(), PropertyExistenceEnforcer.copyAndSortPropertyIds(labelSchemaDescriptor.getPropertyIds()));
        }
        for (RelationTypeSchemaDescriptor relationTypeSchemaDescriptor : rels) {
            PropertyExistenceEnforcer.update(this.mandatoryRelationshipPropertiesByType, relationTypeSchemaDescriptor.getRelTypeId(), PropertyExistenceEnforcer.copyAndSortPropertyIds(relationTypeSchemaDescriptor.getPropertyIds()));
        }
    }

    private static void update(PrimitiveIntObjectMap<int[]> map, int key, int[] sortedValues) {
        int[] current = (int[])map.get(key);
        if (current != null) {
            sortedValues = PrimitiveArrays.union((int[])current, (int[])sortedValues);
        }
        map.put(key, (Object)sortedValues);
    }

    private static int[] copyAndSortPropertyIds(int[] propertyIds) {
        int[] values = new int[propertyIds.length];
        System.arraycopy(propertyIds, 0, values, 0, propertyIds.length);
        Arrays.sort(values);
        return values;
    }

    TxStateVisitor decorate(TxStateVisitor visitor, ReadableTransactionState txState, StoreReadLayer storeLayer) {
        return new Decorator(visitor, txState, storeLayer);
    }

    private void validateNodeProperties(long id, PrimitiveIntSet labelIds, PrimitiveIntSet propertyKeyIds) throws NodePropertyExistenceException {
        if (labelIds.size() > this.mandatoryNodePropertiesByLabel.size()) {
            for (int label : this.mandatoryNodePropertiesByLabel) {
                if (!labelIds.contains(label)) continue;
                this.validateNodeProperties(id, label, (int[])this.mandatoryNodePropertiesByLabel.get(label), propertyKeyIds);
            }
        } else {
            for (int label : labelIds) {
                int[] keys = (int[])this.mandatoryNodePropertiesByLabel.get(label);
                if (keys == null) continue;
                this.validateNodeProperties(id, label, keys, propertyKeyIds);
            }
        }
    }

    private void validateNodeProperties(long id, int label, int[] requiredKeys, PrimitiveIntSet propertyKeyIds) throws NodePropertyExistenceException {
        for (int key : requiredKeys) {
            if (propertyKeyIds.contains(key)) continue;
            this.failNode(id, label, key);
        }
    }

    private void failNode(long id, int label, int propertyKey) throws NodePropertyExistenceException {
        for (LabelSchemaDescriptor constraint : this.nodeConstraints) {
            if (constraint.getLabelId() != label || !this.contains(constraint.getPropertyIds(), propertyKey)) continue;
            throw new NodePropertyExistenceException(constraint, ConstraintValidationException.Phase.VALIDATION, id);
        }
        throw new IllegalStateException(String.format("Node constraint for label=%d, propertyKey=%d should exist.", label, propertyKey));
    }

    private void failRelationship(long id, int relationshipType, int propertyKey) throws RelationshipPropertyExistenceException {
        for (RelationTypeSchemaDescriptor constraint : this.relationshipConstraints) {
            if (constraint.getRelTypeId() != relationshipType || !this.contains(constraint.getPropertyIds(), propertyKey)) continue;
            throw new RelationshipPropertyExistenceException(constraint, ConstraintValidationException.Phase.VALIDATION, id);
        }
        throw new IllegalStateException(String.format("Relationship constraint for relationshipType=%d, propertyKey=%d should exist.", relationshipType, propertyKey));
    }

    private boolean contains(int[] list, int value) {
        for (int x : list) {
            if (value != x) continue;
            return true;
        }
        return false;
    }

    private class Decorator
    extends TxStateVisitor.Delegator {
        private final ReadableTransactionState txState;
        private final StoreReadLayer storeLayer;
        private final PrimitiveIntSet propertyKeyIds;
        private StorageStatement storageStatement;

        Decorator(TxStateVisitor next, ReadableTransactionState txState, StoreReadLayer storeLayer) {
            super(next);
            this.propertyKeyIds = Primitive.intSet();
            this.txState = txState;
            this.storeLayer = storeLayer;
        }

        public void visitNodePropertyChanges(long id, Iterator<StorageProperty> added, Iterator<StorageProperty> changed, Iterator<Integer> removed) throws ConstraintValidationException {
            this.validateNode(id);
            super.visitNodePropertyChanges(id, added, changed, removed);
        }

        public void visitNodeLabelChanges(long id, Set<Integer> added, Set<Integer> removed) throws ConstraintValidationException {
            this.validateNode(id);
            super.visitNodeLabelChanges(id, added, removed);
        }

        public void visitCreatedRelationship(long id, int type, long startNode, long endNode) throws ConstraintValidationException {
            this.validateRelationship(id);
            super.visitCreatedRelationship(id, type, startNode, endNode);
        }

        public void visitRelPropertyChanges(long id, Iterator<StorageProperty> added, Iterator<StorageProperty> changed, Iterator<Integer> removed) throws ConstraintValidationException {
            this.validateRelationship(id);
            super.visitRelPropertyChanges(id, added, changed, removed);
        }

        public void close() {
            super.close();
            if (this.storageStatement != null) {
                this.storageStatement.close();
            }
        }

        private void validateNode(long nodeId) throws NodePropertyExistenceException {
            PrimitiveIntSet labelIds;
            block31: {
                if (PropertyExistenceEnforcer.this.mandatoryNodePropertiesByLabel.isEmpty()) {
                    return;
                }
                try (Cursor<NodeItem> node = this.node(nodeId);){
                    if (node.next()) {
                        labelIds = ((NodeItem)node.get()).labels();
                        if (labelIds.isEmpty()) {
                            return;
                        }
                        this.propertyKeyIds.clear();
                        try (Cursor<PropertyItem> properties = this.properties((NodeItem)node.get());){
                            while (properties.next()) {
                                this.propertyKeyIds.add(((PropertyItem)properties.get()).propertyKeyId());
                            }
                            break block31;
                        }
                    }
                    throw new IllegalStateException(String.format("Node %d with changes should exist.", nodeId));
                }
            }
            PropertyExistenceEnforcer.this.validateNodeProperties(nodeId, labelIds, this.propertyKeyIds);
        }

        private void validateRelationship(long id) throws RelationshipPropertyExistenceException {
            int[] required;
            int relationshipType;
            block32: {
                if (PropertyExistenceEnforcer.this.mandatoryRelationshipPropertiesByType.isEmpty()) {
                    return;
                }
                try (Cursor<RelationshipItem> relationship = this.relationship(id);){
                    if (relationship.next()) {
                        relationshipType = ((RelationshipItem)relationship.get()).type();
                        required = (int[])PropertyExistenceEnforcer.this.mandatoryRelationshipPropertiesByType.get(relationshipType);
                        if (required == null) {
                            return;
                        }
                        this.propertyKeyIds.clear();
                        try (Cursor<PropertyItem> properties = this.properties((RelationshipItem)relationship.get());){
                            while (properties.next()) {
                                this.propertyKeyIds.add(((PropertyItem)properties.get()).propertyKeyId());
                            }
                            break block32;
                        }
                    }
                    throw new IllegalStateException(String.format("Relationship %d with changes should exist.", id));
                }
            }
            for (int mandatory : required) {
                if (this.propertyKeyIds.contains(mandatory)) continue;
                PropertyExistenceEnforcer.this.failRelationship(id, relationshipType, mandatory);
            }
        }

        private Cursor<NodeItem> node(long id) {
            Cursor cursor = this.storeStatement().acquireSingleNodeCursor(id);
            return this.txState.augmentSingleNodeCursor(cursor, id);
        }

        private Cursor<RelationshipItem> relationship(long id) {
            Cursor cursor = this.storeStatement().acquireSingleRelationshipCursor(id);
            return this.txState.augmentSingleRelationshipCursor(cursor, id);
        }

        private Cursor<PropertyItem> properties(NodeItem node) {
            Lock lock = node.lock();
            Cursor cursor = this.storeStatement().acquirePropertyCursor(node.nextPropertyId(), lock, AssertOpen.ALWAYS_OPEN);
            return this.txState.augmentPropertyCursor(cursor, (PropertyContainerState)this.txState.getNodeState(node.id()));
        }

        private Cursor<PropertyItem> properties(RelationshipItem relationship) {
            Lock lock = relationship.lock();
            Cursor cursor = this.storeStatement().acquirePropertyCursor(relationship.nextPropertyId(), lock, AssertOpen.ALWAYS_OPEN);
            return this.txState.augmentPropertyCursor(cursor, (PropertyContainerState)this.txState.getRelationshipState(relationship.id()));
        }

        private StorageStatement storeStatement() {
            return this.storageStatement == null ? (this.storageStatement = this.storeLayer.newStatement()) : this.storageStatement;
        }
    }
}

