/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.enterprise.lock.forseti;

import java.time.Clock;
import java.time.Duration;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.neo4j.collection.pool.LinkedQueuePool;
import org.neo4j.collection.pool.Pool;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.enterprise.lock.forseti.DeadlockStrategies;
import org.neo4j.kernel.impl.enterprise.lock.forseti.ForsetiClient;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.util.collection.SimpleBitSet;
import org.neo4j.storageengine.api.lock.AcquireLockTimeoutException;
import org.neo4j.storageengine.api.lock.ResourceType;
import org.neo4j.storageengine.api.lock.WaitStrategy;

public class ForsetiLockManager
implements Locks {
    private final ConcurrentMap<Long, Lock>[] lockMaps;
    private final ResourceType[] resourceTypes;
    private final Pool<ForsetiClient> clientPool;
    private volatile boolean closed;

    public ForsetiLockManager(Config config, Clock clock, ResourceType ... resourceTypes) {
        int maxResourceId = this.findMaxResourceId(resourceTypes);
        this.lockMaps = new ConcurrentMap[maxResourceId];
        this.resourceTypes = new ResourceType[maxResourceId];
        WaitStrategy[] waitStrategies = new WaitStrategy[maxResourceId];
        for (ResourceType type : resourceTypes) {
            this.lockMaps[type.typeId()] = new ConcurrentHashMap<Long, Lock>(16, 0.6f, 512);
            waitStrategies[type.typeId()] = type.waitStrategy();
            this.resourceTypes[type.typeId()] = type;
        }
        this.clientPool = new ForsetiClientFlyweightPool(config, clock, this.lockMaps, waitStrategies);
    }

    public Locks.Client newClient() {
        if (this.closed) {
            throw new IllegalStateException(this + " already closed");
        }
        ForsetiClient forsetiClient = (ForsetiClient)this.clientPool.acquire();
        forsetiClient.reset();
        return forsetiClient;
    }

    public void accept(Locks.Visitor out) {
        for (int i = 0; i < this.lockMaps.length; ++i) {
            if (this.lockMaps[i] == null) continue;
            ResourceType type = this.resourceTypes[i];
            for (Map.Entry entry : this.lockMaps[i].entrySet()) {
                Lock lock = (Lock)entry.getValue();
                out.visit(type, ((Long)entry.getKey()).longValue(), lock.describeWaitList(), 0L, (long)System.identityHashCode(lock));
            }
        }
    }

    private int findMaxResourceId(ResourceType[] resourceTypes) {
        int max = 0;
        for (ResourceType resourceType : resourceTypes) {
            max = Math.max(resourceType.typeId(), max);
        }
        return max + 1;
    }

    public void close() {
        this.closed = true;
    }

    private static class ForsetiClientFlyweightPool
    extends LinkedQueuePool<ForsetiClient> {
        private final AtomicInteger clientIds = new AtomicInteger(0);
        private final Queue<Integer> unusedIds = new ConcurrentLinkedQueue<Integer>();
        private final ConcurrentMap<Integer, ForsetiClient> clientsById = new ConcurrentHashMap<Integer, ForsetiClient>();
        private final Config config;
        private final Clock clock;
        private final ConcurrentMap<Long, Lock>[] lockMaps;
        private final WaitStrategy<AcquireLockTimeoutException>[] waitStrategies;
        private final DeadlockResolutionStrategy deadlockResolutionStrategy = DeadlockStrategies.DEFAULT;

        ForsetiClientFlyweightPool(Config config, Clock clock, ConcurrentMap<Long, Lock>[] lockMaps, WaitStrategy<AcquireLockTimeoutException>[] waitStrategies) {
            super(128, null);
            this.config = config;
            this.clock = clock;
            this.lockMaps = lockMaps;
            this.waitStrategies = waitStrategies;
        }

        protected ForsetiClient create() {
            Integer id = this.unusedIds.poll();
            if (id == null) {
                id = this.clientIds.getAndIncrement();
            }
            long lockAcquisitionTimeoutMillis = ((Duration)this.config.get(GraphDatabaseSettings.lock_acquisition_timeout)).toMillis();
            ForsetiClient client = new ForsetiClient(id, this.lockMaps, this.waitStrategies, (Pool<ForsetiClient>)this, this.deadlockResolutionStrategy, this.clientsById::get, lockAcquisitionTimeoutMillis, this.clock);
            this.clientsById.put(id, client);
            return client;
        }

        protected void dispose(ForsetiClient resource) {
            super.dispose((Object)resource);
            this.clientsById.remove(resource.id());
            if (resource.id() < 1024) {
                this.unusedIds.offer(resource.id());
            }
        }
    }

    static interface DeadlockResolutionStrategy {
        public boolean shouldAbort(ForsetiClient var1, ForsetiClient var2);
    }

    static interface Lock {
        public void copyHolderWaitListsInto(SimpleBitSet var1);

        public int detectDeadlock(int var1);

        public String describeWaitList();

        public void collectOwners(Set<ForsetiClient> var1);
    }
}

