/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.format.highlimit.v310;

import java.io.IOException;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.impl.store.format.BaseRecordFormat;
import org.neo4j.kernel.impl.store.format.highlimit.Reference;
import org.neo4j.kernel.impl.store.format.highlimit.v310.BaseHighLimitRecordFormatV3_1_0;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;

class RelationshipRecordFormatV3_1_0
extends BaseHighLimitRecordFormatV3_1_0<RelationshipRecord> {
    static final int RECORD_SIZE = 32;
    static final int FIXED_FORMAT_RECORD_SIZE = 32;
    private static final int TYPE_FIELD_BYTES = 3;
    private static final int FIRST_IN_FIRST_CHAIN_BIT = 8;
    private static final int FIRST_IN_SECOND_CHAIN_BIT = 16;
    private static final int HAS_FIRST_CHAIN_NEXT_BIT = 32;
    private static final int HAS_SECOND_CHAIN_NEXT_BIT = 64;
    private static final int HAS_PROPERTY_BIT = 128;
    private static final long FIRST_NODE_BIT = 1L;
    private static final long SECOND_NODE_BIT = 2L;
    private static final long FIRST_PREV_REL_BIT = 4L;
    private static final long FIRST_NEXT_REL_BIT = 8L;
    private static final long SECOND_RREV_REL_BIT = 16L;
    private static final long SECOND_NEXT_REL_BIT = 32L;
    private static final long NEXT_PROP_BIT = 192L;
    private static final long ONE_BIT_OVERFLOW_BIT_MASK = -8589934592L;
    private static final long THREE_BITS_OVERFLOW_BIT_MASK = -17179869184L;
    private static final long HIGH_DWORD_LAST_BIT_MASK = 0x100000000L;
    private static final long TWO_BIT_FIXED_REFERENCE_BIT_MASK = 0x300000000L;

    RelationshipRecordFormatV3_1_0() {
        this(32);
    }

    RelationshipRecordFormatV3_1_0(int recordSize) {
        super(RelationshipRecordFormatV3_1_0.fixedRecordSize((int)recordSize), 0);
    }

    public RelationshipRecord newRecord() {
        return new RelationshipRecord(-1L);
    }

    @Override
    protected void doReadInternal(RelationshipRecord record, PageCursor cursor, int recordSize, long headerByte, boolean inUse) {
        if (record.isUseFixedReferences()) {
            int type = cursor.getShort() & 0xFFFF;
            this.readFixedReferencesRecord(record, cursor, headerByte, inUse, type);
            record.setUseFixedReferences(true);
        } else {
            int typeLowWord = cursor.getShort() & 0xFFFF;
            int typeHighWord = cursor.getByte() & 0xFF;
            int type = typeHighWord << 16 | typeLowWord;
            long recordId = record.getId();
            record.initialize(inUse, RelationshipRecordFormatV3_1_0.decodeCompressedReference(cursor, headerByte, 128, NULL), RelationshipRecordFormatV3_1_0.decodeCompressedReference(cursor), RelationshipRecordFormatV3_1_0.decodeCompressedReference(cursor), type, this.decodeAbsoluteOrRelative(cursor, headerByte, 8, recordId), this.decodeAbsoluteIfPresent(cursor, headerByte, 32, recordId), this.decodeAbsoluteOrRelative(cursor, headerByte, 16, recordId), this.decodeAbsoluteIfPresent(cursor, headerByte, 64, recordId), RelationshipRecordFormatV3_1_0.has((long)headerByte, (int)8), RelationshipRecordFormatV3_1_0.has((long)headerByte, (int)16));
        }
    }

    @Override
    protected byte headerBits(RelationshipRecord record) {
        byte header = 0;
        header = RelationshipRecordFormatV3_1_0.set((byte)header, (int)8, (boolean)record.isFirstInFirstChain());
        header = RelationshipRecordFormatV3_1_0.set((byte)header, (int)16, (boolean)record.isFirstInSecondChain());
        header = RelationshipRecordFormatV3_1_0.set(header, 128, record.getNextProp(), NULL);
        header = RelationshipRecordFormatV3_1_0.set(header, 32, record.getFirstNextRel(), NULL);
        header = RelationshipRecordFormatV3_1_0.set(header, 64, record.getSecondNextRel(), NULL);
        return header;
    }

    @Override
    protected int requiredDataLength(RelationshipRecord record) {
        long recordId = record.getId();
        return 3 + RelationshipRecordFormatV3_1_0.length(record.getNextProp(), NULL) + RelationshipRecordFormatV3_1_0.length(record.getFirstNode()) + RelationshipRecordFormatV3_1_0.length(record.getSecondNode()) + RelationshipRecordFormatV3_1_0.length(this.getFirstPrevReference(record, recordId)) + this.getRelativeReferenceLength(record.getFirstNextRel(), recordId) + RelationshipRecordFormatV3_1_0.length(this.getSecondPrevReference(record, recordId)) + this.getRelativeReferenceLength(record.getSecondNextRel(), recordId);
    }

    @Override
    protected void doWriteInternal(RelationshipRecord record, PageCursor cursor) throws IOException {
        if (record.isUseFixedReferences()) {
            this.writeFixedReferencesRecord(record, cursor);
        } else {
            int type = record.getType();
            cursor.putShort((short)type);
            cursor.putByte((byte)(type >>> 16));
            long recordId = record.getId();
            RelationshipRecordFormatV3_1_0.encode(cursor, record.getNextProp(), NULL);
            RelationshipRecordFormatV3_1_0.encode(cursor, record.getFirstNode());
            RelationshipRecordFormatV3_1_0.encode(cursor, record.getSecondNode());
            RelationshipRecordFormatV3_1_0.encode(cursor, this.getFirstPrevReference(record, recordId));
            if (record.getFirstNextRel() != NULL) {
                RelationshipRecordFormatV3_1_0.encode(cursor, Reference.toRelative(record.getFirstNextRel(), recordId));
            }
            RelationshipRecordFormatV3_1_0.encode(cursor, this.getSecondPrevReference(record, recordId));
            if (record.getSecondNextRel() != NULL) {
                RelationshipRecordFormatV3_1_0.encode(cursor, Reference.toRelative(record.getSecondNextRel(), recordId));
            }
        }
    }

    @Override
    protected boolean canUseFixedReferences(RelationshipRecord record, int recordSize) {
        return !(!this.isRecordBigEnoughForFixedReferences(recordSize) || record.getType() >= 65536 || (record.getFirstNode() & 0xFFFFFFFE00000000L) != 0L || (record.getSecondNode() & 0xFFFFFFFE00000000L) != 0L || record.getFirstPrevRel() != NULL && (record.getFirstPrevRel() & 0xFFFFFFFE00000000L) != 0L || record.getFirstNextRel() != NULL && (record.getFirstNextRel() & 0xFFFFFFFE00000000L) != 0L || record.getSecondPrevRel() != NULL && (record.getSecondPrevRel() & 0xFFFFFFFE00000000L) != 0L || record.getSecondNextRel() != NULL && (record.getSecondNextRel() & 0xFFFFFFFE00000000L) != 0L || record.getNextProp() != NULL && (record.getNextProp() & 0xFFFFFFFC00000000L) != 0L);
    }

    private boolean isRecordBigEnoughForFixedReferences(int recordSize) {
        return 32 <= recordSize;
    }

    private long decodeAbsoluteOrRelative(PageCursor cursor, long headerByte, int firstInStartBit, long recordId) {
        return RelationshipRecordFormatV3_1_0.has((long)headerByte, (int)firstInStartBit) ? RelationshipRecordFormatV3_1_0.decodeCompressedReference(cursor) : Reference.toAbsolute(RelationshipRecordFormatV3_1_0.decodeCompressedReference(cursor), recordId);
    }

    private long getSecondPrevReference(RelationshipRecord record, long recordId) {
        return record.isFirstInSecondChain() ? record.getSecondPrevRel() : Reference.toRelative(record.getSecondPrevRel(), recordId);
    }

    private long getFirstPrevReference(RelationshipRecord record, long recordId) {
        return record.isFirstInFirstChain() ? record.getFirstPrevRel() : Reference.toRelative(record.getFirstPrevRel(), recordId);
    }

    private int getRelativeReferenceLength(long absoluteReference, long recordId) {
        return absoluteReference != NULL ? RelationshipRecordFormatV3_1_0.length(Reference.toRelative(absoluteReference, recordId)) : 0;
    }

    private long decodeAbsoluteIfPresent(PageCursor cursor, long headerByte, int conditionBit, long recordId) {
        return RelationshipRecordFormatV3_1_0.has((long)headerByte, (int)conditionBit) ? Reference.toAbsolute(RelationshipRecordFormatV3_1_0.decodeCompressedReference(cursor), recordId) : NULL;
    }

    private void readFixedReferencesRecord(RelationshipRecord record, PageCursor cursor, long headerByte, boolean inUse, int type) {
        long modifiers = cursor.getByte();
        long firstNode = (long)cursor.getInt() & 0xFFFFFFFFL;
        long firstNodeMod = (modifiers & 1L) << 32;
        long secondNode = (long)cursor.getInt() & 0xFFFFFFFFL;
        long secondNodeMod = (modifiers & 2L) << 31;
        long firstPrevRel = (long)cursor.getInt() & 0xFFFFFFFFL;
        long firstPrevRelMod = (modifiers & 4L) << 30;
        long firstNextRel = (long)cursor.getInt() & 0xFFFFFFFFL;
        long firstNextRelMod = (modifiers & 8L) << 29;
        long secondPrevRel = (long)cursor.getInt() & 0xFFFFFFFFL;
        long secondPrevRelMod = (modifiers & 0x10L) << 28;
        long secondNextRel = (long)cursor.getInt() & 0xFFFFFFFFL;
        long secondNextRelMod = (modifiers & 0x20L) << 27;
        long nextProp = (long)cursor.getInt() & 0xFFFFFFFFL;
        long nextPropMod = (modifiers & 0xC0L) << 26;
        record.initialize(inUse, BaseRecordFormat.longFromIntAndMod((long)nextProp, (long)nextPropMod), BaseRecordFormat.longFromIntAndMod((long)firstNode, (long)firstNodeMod), BaseRecordFormat.longFromIntAndMod((long)secondNode, (long)secondNodeMod), type, BaseRecordFormat.longFromIntAndMod((long)firstPrevRel, (long)firstPrevRelMod), BaseRecordFormat.longFromIntAndMod((long)firstNextRel, (long)firstNextRelMod), BaseRecordFormat.longFromIntAndMod((long)secondPrevRel, (long)secondPrevRelMod), BaseRecordFormat.longFromIntAndMod((long)secondNextRel, (long)secondNextRelMod), RelationshipRecordFormatV3_1_0.has((long)headerByte, (int)8), RelationshipRecordFormatV3_1_0.has((long)headerByte, (int)16));
    }

    private void writeFixedReferencesRecord(RelationshipRecord record, PageCursor cursor) {
        cursor.putShort((short)record.getType());
        long firstNode = record.getFirstNode();
        short firstNodeMod = (short)((firstNode & 0x100000000L) >> 32);
        long secondNode = record.getSecondNode();
        long secondNodeMod = (secondNode & 0x100000000L) >> 31;
        long firstPrevRel = record.getFirstPrevRel();
        long firstPrevRelMod = firstPrevRel == NULL ? 0L : (firstPrevRel & 0x100000000L) >> 30;
        long firstNextRel = record.getFirstNextRel();
        long firstNextRelMod = firstNextRel == NULL ? 0L : (firstNextRel & 0x100000000L) >> 29;
        long secondPrevRel = record.getSecondPrevRel();
        long secondPrevRelMod = secondPrevRel == NULL ? 0L : (secondPrevRel & 0x100000000L) >> 28;
        long secondNextRel = record.getSecondNextRel();
        long secondNextRelMod = secondNextRel == NULL ? 0L : (secondNextRel & 0x100000000L) >> 27;
        long nextProp = record.getNextProp();
        long nextPropMod = nextProp == NULL ? 0L : (nextProp & 0x300000000L) >> 26;
        short modifiers = (short)((long)firstNodeMod | secondNodeMod | firstPrevRelMod | firstNextRelMod | secondPrevRelMod | secondNextRelMod | nextPropMod);
        cursor.putByte((byte)modifiers);
        cursor.putInt((int)firstNode);
        cursor.putInt((int)secondNode);
        cursor.putInt((int)firstPrevRel);
        cursor.putInt((int)firstNextRel);
        cursor.putInt((int)secondPrevRel);
        cursor.putInt((int)secondNextRel);
        cursor.putInt((int)nextProp);
    }
}

