/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.exceptions;

import org.neo4j.exceptions.Neo4jException;
import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.gqlstatus.ErrorGqlStatusObjectImplementation;
import org.neo4j.gqlstatus.GqlHelper;
import org.neo4j.gqlstatus.GqlParams;
import org.neo4j.gqlstatus.GqlStatusInfoCodes;
import org.neo4j.kernel.api.exceptions.Status;

public class CantCompileQueryException
extends Neo4jException {
    public CantCompileQueryException(String message, Throwable cause) {
        super(message, cause);
    }

    public CantCompileQueryException(ErrorGqlStatusObject gqlStatusObject, String message, Throwable cause) {
        super(gqlStatusObject, message, cause);
    }

    public CantCompileQueryException(String message) {
        super(message);
    }

    public CantCompileQueryException(ErrorGqlStatusObject gqlStatusObject, String message) {
        super(gqlStatusObject, message);
    }

    public static CantCompileQueryException unsupportedRuntimeInThisVersion(String runtime) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22000).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_51N27).withParam(GqlParams.StringParam.component, runtime).withParam(GqlParams.StringParam.edition, "community edition").build()).build();
        return new CantCompileQueryException(gql, String.format("This version of Neo4j does not support the requested runtime: `%s`", runtime));
    }

    public static CantCompileQueryException planNotRecognisedInAdminCommand(String unknownPlan) {
        String msg = String.format("Plan is not a recognized database administration command: %s", unknownPlan);
        ErrorGqlStatusObject gql = GqlHelper.get50N00((String)CantCompileQueryException.class.getSimpleName(), (String)msg);
        return new CantCompileQueryException(gql, msg);
    }

    public static CantCompileQueryException planNotSchemaCommand(String unknownPlan) {
        String msg = String.format("Plan is not a schema command: %s", unknownPlan);
        ErrorGqlStatusObject gql = GqlHelper.get50N00((String)CantCompileQueryException.class.getSimpleName(), (String)msg);
        return new CantCompileQueryException(gql, msg);
    }

    public static CantCompileQueryException aggregatingInPipelined(String functionName) {
        String msg = String.format("Pipelined does not yet support the Aggregating function `%s`, use another runtime.", functionName);
        ErrorGqlStatusObject gql = GqlHelper.getGql22000_22N48((String)"pipelined", (String)functionName);
        return new CantCompileQueryException(gql, msg);
    }

    public static CantCompileQueryException mergeNotYetSupported() {
        String msg = "This merge is not yet supported";
        ErrorGqlStatusObject gql = GqlHelper.getGql22000_22N48((String)"pipelined", (String)GqlParams.StringParam.cmd.process((Object)"MERGE"));
        return new CantCompileQueryException(gql, msg);
    }

    public static CantCompileQueryException unsupportedPlanInRuntime(String planComponent, String runtime) {
        String msg = String.format("%s does not yet support the plans including `%s`, use another runtime.", runtime, planComponent);
        ErrorGqlStatusObject gql = GqlHelper.getGql22000_22N48((String)runtime, (String)planComponent);
        return new CantCompileQueryException(gql, msg);
    }

    public static CantCompileQueryException unsupportedFallbackMiddlePlanInRuntime(String planComponent, String runtime) {
        String msg = String.format("%s does not yet support using `%s` as a fallback middle plan, use another runtime.", runtime, planComponent);
        ErrorGqlStatusObject gql = GqlHelper.getGql22000_22N48((String)runtime, (String)planComponent);
        return new CantCompileQueryException(gql, msg);
    }

    public static CantCompileQueryException unsupportedMiddlePlanInRuntime(String planComponent, String runtime) {
        String msg = String.format("%s does not yet support using `%s` as a middle plan, use another runtime.", runtime, planComponent);
        ErrorGqlStatusObject gql = GqlHelper.getGql22000_22N48((String)runtime, (String)planComponent);
        return new CantCompileQueryException(gql, msg);
    }

    public static CantCompileQueryException unsupportedInRuntime(String unsupported, String runtime) {
        String msg = String.format("%s does not yet support %s, use another runtime.", runtime, unsupported);
        ErrorGqlStatusObject gql = GqlHelper.getGql22000_22N48((String)runtime, (String)unsupported);
        return new CantCompileQueryException(gql, msg);
    }

    public static CantCompileQueryException unsupportedInSlotted(String unsupported) {
        String msg = String.format("Slotted runtime does not support %s", unsupported);
        ErrorGqlStatusObject gql = GqlHelper.getGql22000_22N48((String)"slotted", (String)unsupported);
        return new CantCompileQueryException(gql, msg);
    }

    public Status status() {
        return Status.Statement.ExecutionFailed;
    }
}

