/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.exceptions;

import org.neo4j.exceptions.Neo4jException;
import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.gqlstatus.ErrorGqlStatusObjectImplementation;
import org.neo4j.gqlstatus.GqlHelper;
import org.neo4j.gqlstatus.GqlParams;
import org.neo4j.gqlstatus.GqlStatusInfoCodes;
import org.neo4j.kernel.api.exceptions.Status;

public class InvalidSemanticsException
extends Neo4jException {
    @Deprecated
    public InvalidSemanticsException(String message, Throwable cause) {
        super(message, cause);
    }

    public InvalidSemanticsException(ErrorGqlStatusObject gqlStatusObject, String message, Throwable cause) {
        super(gqlStatusObject, message, cause);
    }

    @Deprecated
    public InvalidSemanticsException(String message) {
        super(message);
    }

    public InvalidSemanticsException(ErrorGqlStatusObject gqlStatusObject, String message) {
        super(gqlStatusObject, message);
    }

    public static InvalidSemanticsException invalidCombinationOfProfileAndExplain() {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22000).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22N52).build()).build();
        return new InvalidSemanticsException(gql, "Can't mix PROFILE and EXPLAIN");
    }

    public static InvalidSemanticsException unsupportedAccessOfCompositeDatabase(String accessedGraph, String sessionGraph) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42002).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42N04).withParam(GqlParams.StringParam.db1, accessedGraph).withParam(GqlParams.StringParam.db2, sessionGraph).withParam(GqlParams.StringParam.db3, accessedGraph).build()).build();
        String legacyMessage = "Accessing a composite database and its constituents is only allowed when connected to it. " + "Attempted to access '%s' while connected to '%s'".formatted(accessedGraph, sessionGraph);
        return new InvalidSemanticsException(gql, legacyMessage);
    }

    public static InvalidSemanticsException unsupportedRequestOnSystemDatabase(String invalidInput, String legacyMessage, boolean addSystemProcedureCause) {
        ErrorGqlStatusObject systemProcCause = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42NA9).build();
        ErrorGqlStatusObjectImplementation.Builder disallowedOnSystemCauseBase = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42N17).withParam(GqlParams.StringParam.input, invalidInput);
        ErrorGqlStatusObjectImplementation.Builder disallowedOnSystemCause = addSystemProcedureCause ? disallowedOnSystemCauseBase.withCause(systemProcCause) : disallowedOnSystemCauseBase;
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42001).withCause(disallowedOnSystemCause.build()).build();
        return new InvalidSemanticsException(gql, legacyMessage);
    }

    public static InvalidSemanticsException invalidRegex(String errorMsg, String regex) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22000_22N11((String)regex);
        return new InvalidSemanticsException(gql, "Invalid Regex: " + errorMsg, null);
    }

    public static InvalidSemanticsException accessingMultipleGraphsOnlySupportedOnCompositeDatabases(String legacyMessage) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42001).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42NA5).build()).build();
        return new InvalidSemanticsException(gql, legacyMessage);
    }

    public static InvalidSemanticsException cannotMergeNodeNullProperty(String key, String labelString) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22G03_22N31();
        return new InvalidSemanticsException(gql, String.format("Cannot merge the following node because of null property value for '%s': (%s {%s: null})", key, labelString, key));
    }

    public static InvalidSemanticsException cannotMergeNodeNaNProperty(String key, String labelsString) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22G03_22N31();
        return new InvalidSemanticsException(gql, String.format("Cannot merge the following node because of NaN property value for '%s': (%s {%s: NaN})", key, labelsString, key));
    }

    public static InvalidSemanticsException cannotMergeRelPropertyValue(String value, String key, String startVarPart, String stringifiedRelType, String endVarPart) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22G03_22N31();
        return new InvalidSemanticsException(gql, String.format("Cannot merge the following relationship because of %s property value for '%s': (%s)-[:%s {%s: %s}]->(%s)", value, key, startVarPart, stringifiedRelType, key, value, endVarPart));
    }

    public static InvalidSemanticsException invalidShardTarget(String action, String db1, String db2) {
        ErrorGqlStatusObject gql = GqlHelper.getGql42001_42N0A((String)action, (String)db1, (String)db2);
        return new InvalidSemanticsException(gql, String.format("%s is not allowed with a shard target. Connect to `%s` in order to read or write data from `%s`.", action, db1, db2));
    }

    public Status status() {
        return Status.Statement.SemanticError;
    }
}

