/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.exceptions;

import java.util.List;
import java.util.Locale;
import org.neo4j.exceptions.Neo4jException;
import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.gqlstatus.GqlHelper;
import org.neo4j.gqlstatus.GqlParams;
import org.neo4j.kernel.api.exceptions.Status;

public class ParameterWrongTypeException
extends Neo4jException {
    public ParameterWrongTypeException(String message) {
        super(message);
    }

    private ParameterWrongTypeException(ErrorGqlStatusObject gqlStatusObject, String message) {
        super(gqlStatusObject, message);
    }

    public static ParameterWrongTypeException expectedNodeFoundInstead(String got, String gotPretty, String gotCypherType) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22G03_22N01((String)gotPretty, List.of("NODE"), (String)gotCypherType);
        return new ParameterWrongTypeException(gql, String.format("Expected to find a node but found %s instead", got));
    }

    public static ParameterWrongTypeException expectedNodeAtFoundInstead(String path, String got, String gotPretty, String gotCypherType) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22G03_22N01((String)gotPretty, List.of("NODE"), (String)gotCypherType);
        return new ParameterWrongTypeException(gql, String.format("Expected to find a node at '%s' but found %s instead", path, got));
    }

    public static ParameterWrongTypeException expectedEntityAtRefSlotFoundInstead(int refSlot, String entity, String got, String gotPretty, String gotCypherType) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22G03_22N01((String)gotPretty, List.of(entity.toUpperCase(Locale.ROOT)), (String)gotCypherType);
        return new ParameterWrongTypeException(gql, String.format("Expected to find a %s at ref slot %s but found %s instead", entity, refSlot, got));
    }

    public static ParameterWrongTypeException expectedEntityAtLongSlotFoundInstead(int longSlot, String entity, String got, String gotPretty, String gotCypherType) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22G03_22N01((String)gotPretty, List.of(entity.toUpperCase(Locale.ROOT)), (String)gotCypherType);
        return new ParameterWrongTypeException(gql, String.format("Expected to find a %s at long slot %s but found %s instead", entity, longSlot, got));
    }

    public static ParameterWrongTypeException expectedRelFoundInstead(String got, String gotPretty, String gotCypherType) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22G03_22N01((String)gotPretty, List.of("NODE"), (String)gotCypherType);
        return new ParameterWrongTypeException(gql, String.format("Expected to find a relationship but found %s instead", got));
    }

    public static ParameterWrongTypeException expectedNodeOrRelLabels(String gotPretty, String gotCypherType) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22G03_22N01((String)gotPretty, List.of("NODE", "RELATIONSHIP"), (String)gotCypherType);
        return new ParameterWrongTypeException(gql, "Expected a node or relationship when checking types or labels.");
    }

    public static ParameterWrongTypeException expectedBoolean(String paramName, String input, String prettifiedInput) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22G03_22N27((String)prettifiedInput, (String)GqlParams.StringParam.param.process((Object)paramName), List.of("BOOLEAN"));
        return new ParameterWrongTypeException(gql, String.format("Expected parameter $%s to have type Boolean but was %s", paramName, input));
    }

    public static ParameterWrongTypeException expectedStringOrStringList(String command, String input, String prettifiedInput) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22G03_22N27((String)prettifiedInput, (String)command, List.of("STRING", "LIST<STRING>"));
        return new ParameterWrongTypeException(gql, String.format("Expected a string or a list of strings, but got: %s", input));
    }

    public static ParameterWrongTypeException expectedParameterToBeString(String paramName, String input, String prettifiedInput) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22G03_22N27((String)prettifiedInput, (String)GqlParams.StringParam.param.process((Object)paramName), List.of("STRING"));
        return new ParameterWrongTypeException(gql, String.format("Expected parameter $%s to have type String but was %s", paramName, input));
    }

    public static ParameterWrongTypeException expectedParameterToBeString42N51(boolean prettyPrint, String paramName, String input, String prettifiedInput) {
        String v;
        String p;
        if (prettyPrint) {
            p = String.format("`$%s`", paramName);
            v = String.format("`%s`.", prettifiedInput);
        } else {
            p = String.format("$%s", paramName);
            v = input;
        }
        ErrorGqlStatusObject gql = GqlHelper.getGql42N51((String)paramName, (ErrorGqlStatusObject)GqlHelper.getGql22G03_22N27((String)prettifiedInput, (String)GqlParams.StringParam.param.process((Object)paramName), List.of("STRING")));
        return new ParameterWrongTypeException(gql, String.format("Expected parameter %s to have type String but was %s", p, v));
    }

    public static ParameterWrongTypeException expectedStringButGotValue(String command, String input, String prettifiedInput) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22G03_22N27((String)prettifiedInput, (String)command, List.of("STRING"));
        return new ParameterWrongTypeException(gql, String.format("Expected a string, but got: %s", input));
    }

    public static ParameterWrongTypeException expectedStringButGotType(String paramName, String inputType, String prettifiedInput) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22G03_22N27((String)prettifiedInput, (String)GqlParams.StringParam.param.process((Object)paramName), List.of("STRING"));
        return new ParameterWrongTypeException(gql, String.format("Expected String, but got: %s", inputType));
    }

    public static ParameterWrongTypeException wrongTypeExpectedString(String key, String inputType, String prettifiedInput) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22G03_22N27((String)prettifiedInput, (String)key, List.of("STRING"));
        return new ParameterWrongTypeException(gql, String.format("Parameter '%s' has the wrong type, expected String, got %s.", key, inputType));
    }

    public static ParameterWrongTypeException expectedPasswordToBeString(String passwordParameter, String type) {
        ErrorGqlStatusObject gql = GqlHelper.getGql42N51((String)passwordParameter, (ErrorGqlStatusObject)GqlHelper.getGql22G03_22N27((String)"******", (String)GqlParams.StringParam.param.process((Object)passwordParameter), List.of("STRING")));
        return new ParameterWrongTypeException(gql, String.format("Expected password parameter $%s to have type String but was %s", passwordParameter, type));
    }

    public static ParameterWrongTypeException onlyStringValuesAsPassword(String paramName, String expectedType, String inputType) {
        ErrorGqlStatusObject gql = GqlHelper.getGql42N51((String)paramName, (ErrorGqlStatusObject)GqlHelper.getGql22G03_22N27((String)("type " + inputType), (String)"password", List.of("STRING")));
        return new ParameterWrongTypeException(gql, String.format("Only %s values are accepted as password, got: %s", expectedType, inputType));
    }

    public static ParameterWrongTypeException expectedParameterToBeLiteral(String paramName, String input, String prettifiedInput) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22G03_22N27((String)prettifiedInput, (String)GqlParams.StringParam.param.process((Object)paramName), List.of("BOOLEAN", "STRING", "INTEGER", "FLOAT", "DATE", "LOCAL TIME", "ZONED TIME", "DURATION", "POINT", "LIST<BOOLEAN>", "LIST<STRING>", "LIST<INTEGER>", "LIST<FLOAT>", "LIST<DATE>", "LIST<LOCAL TIME>", "LIST<ZONED TIME>", "LIST<DURATION>", "LIST<POINT>"));
        return new ParameterWrongTypeException(gql, String.format("Expected parameter $%s to be a single literal value but was %s", paramName, input));
    }

    public static ParameterWrongTypeException parameterWrongType(String paramName, String prettifiedInput, String component, String validType) {
        ErrorGqlStatusObject gql = GqlHelper.getGql42N51((String)paramName, (ErrorGqlStatusObject)GqlHelper.getGql22G03_22N27((String)prettifiedInput, (String)component, List.of(validType)));
        return new ParameterWrongTypeException(gql, GqlHelper.getCompleteMessage((ErrorGqlStatusObject)gql));
    }

    public Status status() {
        return Status.Statement.TypeError;
    }
}

