/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.exceptions;

import java.util.List;
import org.neo4j.exceptions.Neo4jException;
import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.gqlstatus.ErrorGqlStatusObjectImplementation;
import org.neo4j.gqlstatus.GqlHelper;
import org.neo4j.gqlstatus.GqlParams;
import org.neo4j.gqlstatus.GqlStatusInfoCodes;
import org.neo4j.kernel.api.exceptions.Status;

public class CypherTypeException
extends Neo4jException {
    protected CypherTypeException(ErrorGqlStatusObject gqlStatusObject, String message, Throwable cause) {
        super(gqlStatusObject, message, cause);
    }

    @Deprecated
    public CypherTypeException(String message) {
        super(message);
    }

    protected CypherTypeException(ErrorGqlStatusObject gqlStatusObject, String message) {
        super(gqlStatusObject, message);
    }

    public static CypherTypeException internalError(String msgTitle, String message) {
        ErrorGqlStatusObject gql = GqlHelper.get50N00((String)msgTitle, (String)message);
        return new CypherTypeException(gql, message);
    }

    public static CypherTypeException invalidType(String value, List<String> expectedTypes, String actualType, String signature) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22G03_22N01((String)value, expectedTypes, (String)actualType);
        return new CypherTypeException(gql, String.format("Wrong type. Expected %s, got %s", signature, actualType));
    }

    public static CypherTypeException invalidTypeForLabelExpression(String value, String prettyValue, String actualType, String actualCypherType) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22G03_22N01((String)prettyValue, List.of("NODE", "RELATIONSHIP"), (String)actualCypherType);
        return new CypherTypeException(gql, String.format("Invalid input for function 'hasALabelOrType()': Expected %s to be a node or relationship, but it was `%s`", value, actualType));
    }

    public static CypherTypeException nodeCreationNotAMap(String value, String gotCypherType) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22G03_22N01((String)value, List.of("MAP"), (String)gotCypherType);
        return new CypherTypeException(gql, String.format("Parameter provided for node creation is not a Map, instead got %s", value));
    }

    public static CypherTypeException expectedMap(String got, String gotPretty, String gotCypherType) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22G03_22N01((String)gotPretty, List.of("MAP"), (String)gotCypherType);
        return new CypherTypeException(gql, String.format("Type mismatch: expected a map but was %s", got));
    }

    public static CypherTypeException expectedExpressionToBeMap(String expression, String got, String gotPretty, String gotCypherType) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22G03_22N01((String)gotPretty, List.of("MAP"), (String)gotCypherType);
        return new CypherTypeException(gql, String.format("Expected %s to be a map, but it was :`%s`", expression, got));
    }

    public static CypherTypeException expectedPathButGot(String gotPretty, String gotType, String gotCypherType) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22G03_22N01((String)gotPretty, List.of("PATH"), (String)gotCypherType);
        return new CypherTypeException(gql, String.format("Expected path but got %s", gotType));
    }

    public static CypherTypeException expectedNodeRelPath(String gotPretty, String gotClass, String gotCypherType) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22G03_22N01((String)gotPretty, List.of("NODE", "RELATIONSHIP", "PATH"), (String)gotCypherType);
        return new CypherTypeException(gql, String.format("Expected a Node, Relationship or Path, but got a %s", gotClass));
    }

    public static CypherTypeException expectedNodeRelWas(String got, String gotClass, String gotPretty, String gotCypherType) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22G03_22N01((String)gotPretty, List.of("NODE", "RELATIONSHIP"), (String)gotCypherType);
        return new CypherTypeException(gql, String.format("Expected %s to be a Node or Relationship, but it was a %s", got, gotClass));
    }

    public static CypherTypeException expectedNodeRel(String gotClass, String gotPretty, String gotCypherType) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22G03_22N01((String)gotPretty, List.of("NODE", "RELATIONSHIP"), (String)gotCypherType);
        return new CypherTypeException(gql, String.format("Expected a Node or Relationship, but got a %s", gotClass));
    }

    public static CypherTypeException expectedListValue(String got, String gotPretty, String gotCypherType) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22G03_22N01((String)gotPretty, List.of("LIST"), (String)gotCypherType);
        return new CypherTypeException(gql, String.format("Expected ListValue but got %s", got));
    }

    public static CypherTypeException expectedList(String got, String gotPretty, String gotCypherType) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22G03_22N01((String)gotPretty, List.of("LIST"), (String)gotCypherType);
        return new CypherTypeException(gql, String.format("Expected list, got %s", got));
    }

    public static CypherTypeException expectedListFound(String got, String gotPretty, String gotCypherType) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22G03_22N01((String)gotPretty, List.of("LIST"), (String)gotCypherType);
        return new CypherTypeException(gql, String.format("Expected list but found: %s", got));
    }

    public static CypherTypeException expectedCollection(String got, String gotPretty, String gotCypherType) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22G03_22N01((String)gotPretty, List.of("LIST"), (String)gotCypherType);
        return new CypherTypeException(gql, String.format("Expected a collection, got `%s`", got));
    }

    public static CypherTypeException expectedCollectionWasNot(String got, String gotPretty, String gotCypherType) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22G03_22N01((String)gotPretty, List.of("LIST"), (String)gotCypherType);
        return new CypherTypeException(gql, String.format("Expected the value for %s to be a collection but it was not.", got));
    }

    public static CypherTypeException planExpectedNode(String gotPretty, String gotCypherType) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22G03_22N01((String)gotPretty, List.of("NODE"), (String)gotCypherType);
        return new CypherTypeException(gql, "Created a plan that uses non-nodes when expecting a node");
    }

    public static CypherTypeException notBool(String got, String gotPretty, String gotCypherType) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22G03_22N01((String)gotPretty, List.of("BOOLEAN"), (String)gotCypherType);
        return new CypherTypeException(gql, String.format("%s is not a boolean value", got));
    }

    public static CypherTypeException cantTreatAsBool(String got, String gotPretty, String gotCypherType) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22G03_22N01((String)gotPretty, List.of("BOOLEAN"), (String)gotCypherType);
        return new CypherTypeException(gql, String.format("Don't know how to treat that as a boolean: %s", got));
    }

    public static CypherTypeException notNode(String got, String gotType) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22G03_22N01((String)got, List.of("NODE"), (String)gotType);
        return new CypherTypeException(gql, String.format("%s is not a node", got));
    }

    public static CypherTypeException expectedString(String msg, String gotPretty, String gotCypherType) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22G03_22N01((String)gotPretty, List.of("STRING"), (String)gotCypherType);
        return new CypherTypeException(gql, msg);
    }

    public static CypherTypeException expectedStringNotNull(String msg, String gotPretty, String gotCypherType) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22G03_22N01((String)gotPretty, List.of("STRING NOT NULL"), (String)gotCypherType);
        return new CypherTypeException(gql, msg);
    }

    public static CypherTypeException expectedStringOrListOfStringsNotNull(String msg, String gotPretty, String gotCypherType) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22G03_22N01((String)gotPretty, List.of("STRING NOT NULL", "LIST<STRING NOT NULL>"), (String)gotCypherType);
        return new CypherTypeException(gql, msg);
    }

    public static CypherTypeException expectedNumber(String msg, String gotPretty, String gotCypherType) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22G03_22N01((String)gotPretty, List.of("INTEGER", "FLOAT"), (String)gotCypherType);
        return new CypherTypeException(gql, msg);
    }

    public static CypherTypeException expectedInteger(String msg, String gotPretty, String gotCypherType) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22G03_22N01((String)gotPretty, List.of("INTEGER"), (String)gotCypherType);
        return new CypherTypeException(gql, msg);
    }

    public static CypherTypeException functionArgumentWrongType(String msg, String functionName, String gotPretty, List<String> expectedList, String gotCypherType) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22N38_22N01((String)GqlParams.StringParam.fun.process((Object)functionName), (String)gotPretty, expectedList, (String)gotCypherType);
        return new CypherTypeException(gql, msg);
    }

    public static CypherTypeException expectedNumericGotNull(String target) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22G03_22N01((String)"NULL", List.of("INTEGER", "FLOAT"), (String)"NULL");
        return new CypherTypeException(gql, String.format("Expected a numeric value for %s, but got null", target));
    }

    public static CypherTypeException expectedNumericGot(String target, String got, String gotPretty, String gotCypherType) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22G03_22N01((String)gotPretty, List.of("INTEGER", "FLOAT"), (String)gotCypherType);
        return new CypherTypeException(gql, String.format("Expected a numeric value for %s, but got: %s", target, got));
    }

    public static CypherTypeException expectedVirtualNode(String gotPretty, String gotTypeName, String gotCypherType) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22G03_22N01((String)gotPretty, List.of("NODE"), (String)gotCypherType);
        return new CypherTypeException(gql, String.format("Expected VirtualNodeValue got %s", gotTypeName));
    }

    public static CypherTypeException expectedNodeValue(String gotPretty, String gotTypeName, String gotCypherType) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22G03_22N01((String)gotPretty, List.of("NODE"), (String)gotCypherType);
        return new CypherTypeException(gql, String.format("Expected NodeValue but got %s", gotTypeName));
    }

    public static CypherTypeException typeMismatchExpectedANode(String got, String gotPretty, String gotCypherType) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22G03_22N01((String)gotPretty, List.of("NODE"), (String)gotCypherType);
        return new CypherTypeException(gql, String.format("Type mismatch: expected a node but was %s", got));
    }

    public static CypherTypeException typeMismatchExpectedANodeWasType(String got, String gotClass, String gotPretty, String gotCypherType) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22G03_22N01((String)gotPretty, List.of("NODE"), (String)gotCypherType);
        return new CypherTypeException(gql, String.format("Type mismatch: expected a node but was %s of type %s", got, gotClass));
    }

    public static CypherTypeException expectedNode(String got, String gotPretty, String gotCypherType) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22G03_22N01((String)gotPretty, List.of("NODE"), (String)gotCypherType);
        return new CypherTypeException(gql, String.format("Expected a Node, got: %s", got));
    }

    public static CypherTypeException expectedNodeButGot(String gotPretty, String gotType, String gotCypherType) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22G03_22N01((String)gotPretty, List.of("NODE"), (String)gotCypherType);
        return new CypherTypeException(gql, String.format("Expected node but got %s", gotType));
    }

    public static CypherTypeException expectedANodeButGot(String gotPretty, String gotType, String gotCypherType) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22G03_22N01((String)gotPretty, List.of("NODE"), (String)gotCypherType);
        return new CypherTypeException(gql, String.format("Expected a node, but got %s ", gotType));
    }

    public static CypherTypeException expectedNodeButGotNull() {
        ErrorGqlStatusObject gql = GqlHelper.getGql22G03_22N01((String)"NULL", List.of("NODE"), (String)"NULL");
        return new CypherTypeException(gql, "Expected a node, but got null ");
    }

    public static CypherTypeException expectedRelButGot(String gotPretty, String gotType, String gotCypherType) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22G03_22N01((String)gotPretty, List.of("RELATIONSHIP"), (String)gotCypherType);
        return new CypherTypeException(gql, String.format("Expected relationship but got %s", gotType));
    }

    public static CypherTypeException typeMismatchExpectedARel(String got, String gotPretty, String gotCypherType) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22G03_22N01((String)gotPretty, List.of("RELATIONSHIP"), (String)gotCypherType);
        return new CypherTypeException(gql, String.format("Type mismatch: expected a relationship but was %s", got));
    }

    public static CypherTypeException expectedRel(String got, String gotPretty, String gotCypherType) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22G03_22N01((String)gotPretty, List.of("RELATIONSHIP"), (String)gotCypherType);
        return new CypherTypeException(gql, String.format("Expected a Relationship, got: %s", got));
    }

    public static CypherTypeException expectedOtherType(String got, String expectedType, String gotType, String gotPretty, String gotCypherType) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22G03_22N01((String)gotPretty, List.of(expectedType), (String)gotCypherType);
        return new CypherTypeException(gql, String.format("Expected %s to be a %s, but it was a %s", got, expectedType, gotType));
    }

    public static CypherTypeException howTreatPredicate(String got, String gotPretty, String gotCypherType) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22G03_22N01((String)gotPretty, List.of("BOOLEAN"), (String)gotCypherType);
        return new CypherTypeException(gql, String.format("Don't know how to treat a predicate: %s", got), null);
    }

    public static CypherTypeException howTreatAsPredicate(String got, String gotPretty, String gotCypherType) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22G03_22N01((String)gotPretty, List.of("BOOLEAN"), (String)gotCypherType);
        return new CypherTypeException(gql, String.format("Don't know how to treat that as a predicate: %s", got));
    }

    public static CypherTypeException expectedPrimitivePropertyValue(String got, String gotPretty, String gotCypherType, Boolean withEncountered) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22G03_22N01((String)gotPretty, List.of("BOOLEAN", "STRING", "INTEGER", "FLOAT", "DATE", "LOCAL TIME", "ZONED TIME", "LOCAL DATETIME", "ZONED DATETIME", "DURATION", "POINT"), (String)gotCypherType);
        Object msg = "Property values can only be of primitive types or arrays thereof";
        if (withEncountered.booleanValue()) {
            msg = (String)msg + String.format(". Encountered: %s.", got);
        }
        return new CypherTypeException(gql, (String)msg);
    }

    public static CypherTypeException expectedRelValue(String got, String gotPretty, String gotCypherType) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22G03_22N01((String)gotPretty, List.of("RELATIONSHIP"), (String)gotCypherType);
        return new CypherTypeException(gql, String.format("Expected %s to be a RelationshipValue", got));
    }

    public static CypherTypeException expectedRelValueGotType(String gotType, String gotPretty, String gotCypherType) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22G03_22N01((String)gotPretty, List.of("RELATIONSHIP"), (String)gotCypherType);
        return new CypherTypeException(gql, String.format("Expected RelationshipValue but got %s", gotType));
    }

    public static CypherTypeException notCollectionOrMap(String got, String gotPretty, String gotCypherType, Object index) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22G03_22N01((String)gotPretty, List.of("LIST", "MAP"), (String)gotCypherType);
        return new CypherTypeException(gql, String.format("`%s` is not a collection or a map. Element access is only possible by performing a collection lookup using an integer index, or by performing a map lookup using a string key (found: %s[%s])", got, got, index));
    }

    public static CypherTypeException notMap(String got, String gotPretty, String gotCypherType, Object index) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22G03_22N01((String)gotPretty, List.of("MAP"), (String)gotCypherType);
        return new CypherTypeException(gql, String.format("`%s` is not a map. Element access is only possible by performing a collection lookup by performing a map lookup using a string key (found: %s[%s])", got, got, index));
    }

    public static CypherTypeException nonIntegerListIndex(String got, String gotPretty, String gotCypherType) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22G03_22N01((String)gotPretty, List.of("INTEGER"), (String)gotCypherType);
        return new CypherTypeException(gql, String.format("Cannot access a list using an non-integer number index, got %s", got), null);
    }

    public static CypherTypeException addTypeMismatch(String leftPretty, String leftTypeName, String rightTypeName, String leftCypherType, String rightCypherType) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22G03_22N01((String)leftPretty, List.of(rightCypherType), (String)leftCypherType);
        return new CypherTypeException(gql, String.format("Cannot add `%s` and `%s`", leftTypeName, rightTypeName));
    }

    public static CypherTypeException subtractTypeMismatch(String leftPretty, String leftTypeName, String rightTypeName, String leftCypherType, String rightCypherType) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22G03_22N01((String)leftPretty, List.of(rightCypherType), (String)leftCypherType);
        return new CypherTypeException(gql, String.format("Cannot subtract `%s` from `%s`", rightTypeName, leftTypeName));
    }

    public static CypherTypeException divideTypeMismatch(String leftPretty, String leftTypeName, String rightTypeName, String leftCypherType, String rightCypherType) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22G03_22N01((String)leftPretty, List.of(rightCypherType), (String)leftCypherType);
        return new CypherTypeException(gql, String.format("Cannot divide `%s` by `%s`", leftTypeName, rightTypeName));
    }

    public static CypherTypeException multiplyTypeMismatch(String leftPretty, String leftTypeName, String rightTypeName, String leftCypherType, String rightCypherType) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22G03_22N01((String)leftPretty, List.of(rightCypherType), (String)leftCypherType);
        return new CypherTypeException(gql, String.format("Cannot multiply `%s` and `%s`", leftTypeName, rightTypeName));
    }

    public static CypherTypeException modulusTypeMismatch(String leftPretty, String leftTypeName, String rightTypeName, String leftCypherType, String rightCypherType) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22G03_22N01((String)leftPretty, List.of(rightCypherType), (String)leftCypherType);
        return new CypherTypeException(gql, String.format("Cannot calculate modulus of `%s` and `%s`", leftTypeName, rightTypeName));
    }

    public static CypherTypeException powerTypeMismatch(String leftPretty, String leftTypeName, String rightTypeName, String leftCypherType, String rightCypherType) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22G03_22N01((String)leftPretty, List.of(rightCypherType), (String)leftCypherType);
        return new CypherTypeException(gql, String.format("Cannot raise `%s` to the power of `%s`", leftTypeName, rightTypeName));
    }

    public static CypherTypeException propertyParamIsNotMap(String got, String gotPretty, String gotCypherType) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22G03_22N01((String)gotPretty, List.of("MAP"), (String)gotCypherType);
        return new CypherTypeException(gql, String.format("Parameter provided for setting properties is not a Map, instead got %s", got));
    }

    public static CypherTypeException propertyWithRelCollection(List<?> collection) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22G03_22N39((String)String.valueOf(collection));
        return new CypherTypeException(gql, "Collections containing relationship values can not be stored in properties.");
    }

    public static CypherTypeException propertyWithNullInCollection(String serializedList) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22G03_22N39((String)serializedList);
        return new CypherTypeException(gql, "Collections containing null values can not be stored in properties.");
    }

    public static CypherTypeException propertyWithCollectionInCollection(String serializedList) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22G03_22N39((String)serializedList);
        return new CypherTypeException(gql, "Collections containing collections can not be stored in properties.");
    }

    public static CypherTypeException genericPropertyError(String value) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22G03_22N39((String)value);
        return new CypherTypeException(gql, "Neo4j only supports a subset of Cypher types for storage as singleton or array properties. Please refer to section cypher/syntax/values of the manual for more details.");
    }

    public static CypherTypeException collectionDifferentCRSPoints(String collection) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22G03_22N39((String)String.valueOf(collection));
        return new CypherTypeException(gql, "Collections containing point values with different CRS can not be stored in properties.");
    }

    public static CypherTypeException collectionDifferentDimPoints(String collection) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22G03_22N39((String)String.valueOf(collection));
        return new CypherTypeException(gql, "Collections containing point values with different dimensions can not be stored in properties.");
    }

    public static CypherTypeException expectedNodeAtRow(String row, String got) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22G03_22N27((String)row, (String)got, List.of("NODE"));
        return new CypherTypeException(gql, String.format("Expected a node at `%s` but got %s", row, got));
    }

    public static CypherTypeException onlyNumericalValuesOrNullAllowed(String function, String value, String actualType, String actualCypherType) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22N38_22N01((String)function, (String)value, List.of("INTEGER", "FLOAT"), (String)actualCypherType);
        return new CypherTypeException(gql, String.format("%s can only handle numerical values or null, but received: %s", function, actualType));
    }

    public static CypherTypeException onlyNumericalValuesDurationsOrNullAllowed(String function, String value, String actualType, String actualCypherType) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22N38_22N01((String)function, (String)value, List.of("INTEGER", "FLOAT", "DURATION"), (String)actualCypherType);
        return new CypherTypeException(gql, String.format("%s can only handle numerical values, duration, or null, but received: %s", function, actualType));
    }

    public static CypherTypeException onlyNumericalValuesAllowed(String function, String value, String actualCypherType) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22N38_22N01((String)function, (String)value, List.of("INTEGER", "FLOAT"), (String)actualCypherType);
        return new CypherTypeException(gql, String.format("%s cannot mix number and duration", function));
    }

    public static CypherTypeException onlyDurationValuesAllowed(String function, String value, String actualCypherType) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22N38_22N01((String)function, (String)value, List.of("DURATION"), (String)actualCypherType);
        return new CypherTypeException(gql, String.format("%s cannot mix number and duration", function));
    }

    public static CypherTypeException onlyDurationValuesAllowedButNumberFound(String function) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22N38_22NB1((String)function, List.of("DURATION"), (String)"NUMERIC");
        return new CypherTypeException(gql, String.format("%s cannot mix number and duration", function));
    }

    public static CypherTypeException onlyNumberValuesAllowedButDurationFound(String function) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22N38_22NB1((String)function, List.of("NUMERIC"), (String)"DURATION");
        return new CypherTypeException(gql, String.format("%s cannot mix number and duration", function));
    }

    public static CypherTypeException invalidCoercion(String value, String expectedType, String legacyMessage) {
        return new CypherTypeException(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22G03).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22N37).withParam(GqlParams.StringParam.value, value).withParam(GqlParams.StringParam.valueType, expectedType).build()).build(), legacyMessage);
    }

    public static CypherTypeException integerOutOfBounds(String component, Number lower, Number upper, String input) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22003_22N03((String)component, (String)"INTEGER", (Number)lower, (Number)upper, (String)input);
        return new CypherTypeException(gql, String.format("integer, %s, is too large", input));
    }

    public Status status() {
        return Status.Statement.TypeError;
    }
}

