/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.exceptions;

import java.util.Objects;
import java.util.Optional;
import org.neo4j.exceptions.Neo4jException;
import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.gqlstatus.ErrorGqlStatusObjectImplementation;
import org.neo4j.gqlstatus.GqlHelper;
import org.neo4j.gqlstatus.GqlParams;
import org.neo4j.gqlstatus.GqlStatusInfoCodes;
import org.neo4j.kernel.api.exceptions.Status;

public class SyntaxException
extends Neo4jException {
    private final transient Integer offset;
    private final String query;
    public static final String QUOTE_MISMATCH_ERROR_MESSAGE = "Failed to parse string literal. The query must contain an even number of non-escaped quotes.";

    @Deprecated
    public SyntaxException(String message, String query, Integer offset, Throwable cause) {
        super(message, cause);
        this.offset = offset;
        this.query = query;
    }

    protected SyntaxException(ErrorGqlStatusObject gqlStatusObject, String message, String query, Integer offset, Throwable cause) {
        super(gqlStatusObject, message, cause);
        this.offset = offset;
        this.query = query;
    }

    @Deprecated
    public SyntaxException(String message, String query, int offset) {
        this(message, query, offset, null);
    }

    public SyntaxException(ErrorGqlStatusObject gqlStatusObject, String message, String query, int offset) {
        this(gqlStatusObject, message, query, offset, null);
    }

    protected SyntaxException(ErrorGqlStatusObject gqlStatusObject, String message, Throwable cause) {
        this(gqlStatusObject, message, "", null, cause);
    }

    @Deprecated
    public SyntaxException(String message) {
        this(message, "", null, null);
    }

    public SyntaxException(ErrorGqlStatusObject gqlStatusObject, String message) {
        this(gqlStatusObject, message, "", null, null);
    }

    public static SyntaxException internalError(String msgTitle, String message, String query, int offset) {
        ErrorGqlStatusObject gql = GqlHelper.get50N00((String)msgTitle, (String)message);
        return new SyntaxException(gql, message, query, offset, null);
    }

    public static SyntaxException internalError(String msgTitle, String message) {
        ErrorGqlStatusObject gql = GqlHelper.get50N00((String)msgTitle, (String)message);
        return new SyntaxException(gql, message);
    }

    public static SyntaxException invalidShortestPathException(String start) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22000).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22N33).build()).build();
        return new SyntaxException(gql, String.format("To find a shortest path, both ends of the path need to be provided. Couldn't find `%s`", start));
    }

    public static SyntaxException wrongNumberOfArguments(int expectedCount, int actualCount, String name, String signature) {
        String msg = String.format("The procedure or function call does not provide the required number of arguments; expected %s but got %s. The procedure or function `%s` has the signature: `%s`.", expectedCount, actualCount, name, signature);
        return SyntaxException.wrongNumberOfArguments(expectedCount, actualCount, name, signature, msg);
    }

    public static SyntaxException wrongNumberOfArguments(int expectedCount, int actualCount, String name, String signature, String legacyMessage) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42001).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42I13).withParam(GqlParams.NumberParam.count1, (Number)expectedCount).withParam(GqlParams.NumberParam.count2, (Number)actualCount).withParam(GqlParams.StringParam.procFun, name).withParam(GqlParams.StringParam.sig, signature).build()).build();
        return new SyntaxException(gql, legacyMessage);
    }

    public static SyntaxException variableAlreadyBound(String variable, String clause) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42N78).withParam(GqlParams.StringParam.variable, variable).withParam(GqlParams.StringParam.clause, clause).build();
        return new SyntaxException(gql, String.format("Can't create node `%s` with labels or properties here. The variable is already declared in this context", variable));
    }

    public static SyntaxException accessingMultipleGraphsOnlySupportedOnCompositeDatabases(String legacyMessage, String query, int offset) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42001).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42NA5).build()).build();
        return new SyntaxException(gql, legacyMessage, query, offset);
    }

    public static SyntaxException invalidNestedUseClause(String db1, String db2, String legacyMessage, String query, int offset) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42001).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42N74).withParam(GqlParams.StringParam.db1, db1).withParam(GqlParams.StringParam.db2, db2).build()).build();
        return new SyntaxException(gql, legacyMessage, query, offset);
    }

    public static SyntaxException stringLiteralWithInvalidQuotes() {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42001).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42I19).build()).build();
        return new SyntaxException(gql, QUOTE_MISMATCH_ERROR_MESSAGE);
    }

    public static SyntaxException cannotYieldFromVoidProcedure() {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42001).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42I42).build()).build();
        return new SyntaxException(gql, "Cannot yield value from void procedure.");
    }

    public static SyntaxException unknownFunction(String functionName, int offset, int line, int column) {
        ErrorGqlStatusObject gql = GqlHelper.getGql42001_42N48((String)functionName, (int)offset, (int)line, (int)column);
        return new SyntaxException(gql, String.format("Unknown function '%s'", functionName));
    }

    public static SyntaxException dynamicGraphReferenceUnsupported(String legacyMsg, String query, int offset, int line, int column) {
        ErrorGqlStatusObject gql = GqlHelper.getGql42001_42N72((int)offset, (int)line, (int)column);
        return new SyntaxException(gql, legacyMsg, query, offset);
    }

    public static SyntaxException invalidUseOfAggregateFunction(String functionType, String legacyMessage) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22000).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22N34).withParam(GqlParams.StringParam.funType, functionType).build()).build();
        return new SyntaxException(gql, legacyMessage);
    }

    public Status status() {
        return Status.Statement.SyntaxError;
    }

    public Optional<Integer> getOffset() {
        return Optional.ofNullable(this.offset);
    }

    public String getMessage() {
        if (Objects.nonNull(this.offset)) {
            String[] stringArray;
            String[] split = this.query.split("\n");
            String string = super.getMessage();
            String string2 = System.lineSeparator();
            int n = this.offset;
            if (split.length != 0) {
                stringArray = split;
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = "";
            }
            return string + string2 + SyntaxException.findErrorLine(n, stringArray);
        }
        return super.getMessage();
    }

    private static String findErrorLine(int offset, String[] message) {
        int currentOffset = offset;
        if (message.length == 0) {
            throw new IllegalArgumentException("message converted to empty list");
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < message.length; ++i) {
            String element = message[i];
            if (i < message.length - 1) {
                if (element.length() >= currentOffset) {
                    SyntaxException.buildErrorString(builder, element, currentOffset);
                    break;
                }
                currentOffset -= element.length() + 1;
                continue;
            }
            SyntaxException.buildErrorString(builder, element, Math.min(element.length(), currentOffset));
        }
        return builder.toString();
    }

    private static void buildErrorString(StringBuilder builder, String element, int currentOffset) {
        builder.append("\"").append(element.stripTrailing()).append("\"").append(System.lineSeparator()).append(" ".repeat(currentOffset + 1)).append('^');
    }
}

