/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.exceptions;

import org.neo4j.exceptions.KernelException;
import org.neo4j.exceptions.Neo4jException;
import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.gqlstatus.ErrorGqlStatusObjectImplementation;
import org.neo4j.gqlstatus.GqlHelper;
import org.neo4j.gqlstatus.GqlParams;
import org.neo4j.gqlstatus.GqlStatusInfoCodes;
import org.neo4j.kernel.api.exceptions.Status;

public class CypherExecutionException
extends Neo4jException {
    @Deprecated
    public CypherExecutionException(String message, Throwable cause) {
        super(message, cause);
    }

    public CypherExecutionException(ErrorGqlStatusObject gqlStatusObject, String message, Throwable cause) {
        super(gqlStatusObject, message, cause);
    }

    @Deprecated
    public CypherExecutionException(String message) {
        super(message);
    }

    protected CypherExecutionException(ErrorGqlStatusObject gqlStatusObject, String message) {
        super(gqlStatusObject, message);
    }

    private <EX extends Throwable> CypherExecutionException(EX cause) {
        super((ErrorGqlStatusObject)cause, cause.getMessage(), cause);
    }

    public static <EX extends Throwable> CypherExecutionException wrapError(EX e) {
        if (((ErrorGqlStatusObject)e).gqlStatusObject() != null) {
            return new CypherExecutionException(e);
        }
        return new CypherExecutionException(GqlHelper.getDefaultObject(), e.getMessage(), e);
    }

    public static CypherExecutionException wrapKernelException(String msg, KernelException e) {
        if (e.gqlStatusObject() != null) {
            return new CypherExecutionException((ErrorGqlStatusObject)e, msg, (Throwable)e);
        }
        return new CypherExecutionException(GqlHelper.getDefaultObject(), msg, (Throwable)e);
    }

    public static CypherExecutionException csvBufferSizeOverflow(Throwable cause) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22000).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22N49).build()).build();
        return new CypherExecutionException(gql, "Tried to read a field larger than the current buffer size.\n Make sure that the field doesn't have an unterminated quote,\n if it doesn't you can try increasing the buffer size via `dbms.import.csv.buffer_size`.", cause);
    }

    public static CypherExecutionException internalError(String msgTitle, String msg) {
        ErrorGqlStatusObject gql = GqlHelper.get50N00((String)msgTitle, (String)msg);
        return new CypherExecutionException(gql, msg);
    }

    public static CypherExecutionException internalError(String msgTitle, String msg, Throwable cause) {
        ErrorGqlStatusObject gql = GqlHelper.get50N00((String)msgTitle, (String)msg);
        return new CypherExecutionException(gql, msg, cause);
    }

    public static CypherExecutionException queryExecutionFailed(Throwable cause) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_50N42).build();
        return new CypherExecutionException(gql, "Query execution failed", cause);
    }

    public static CypherExecutionException unknownError(Throwable cause) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_50N42).build();
        return new CypherExecutionException(gql, cause.getMessage(), cause);
    }

    public static CypherExecutionException unexpectedError(Throwable cause) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_50N00).withParam(GqlParams.StringParam.msgTitle, "Unexpected error").withParam(GqlParams.StringParam.msg, cause.getMessage()).build();
        return new CypherExecutionException(gql, cause.getMessage(), cause);
    }

    public static CypherExecutionException unrecognisedExecutionMode(String procedure, String mode) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_52N02).withParam(GqlParams.StringParam.proc, procedure).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_52N03).withParam(GqlParams.StringParam.proc, procedure).withParam(GqlParams.StringParam.procExeMode, mode).build()).build();
        return new CypherExecutionException(gql, "Unable to execute procedure, because it requires an unrecognized execution mode: " + mode, null);
    }

    public static CypherExecutionException unrecognisedCypherType(String input) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42001).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42N52).withParam(GqlParams.StringParam.input, input).build()).build();
        return new CypherExecutionException(gql, "Unable to execute procedure, because the signature has an unrecognized type: " + input, null);
    }

    public static CypherExecutionException failedCopyPrivileges(String to, String from, Throwable cause) {
        String msg = String.format("Failed to create role '%s' as copy of '%s': Failed to copy privileges.", to, from);
        ErrorGqlStatusObject gql = GqlHelper.get50N00((String)CypherExecutionException.class.getSimpleName(), (String)msg);
        return new CypherExecutionException(gql, msg, cause);
    }

    public static CypherExecutionException failedToAlterDb(String dbName, Throwable cause) {
        String msg = String.format("Failed to alter the specified database '%s'.", dbName);
        ErrorGqlStatusObject gql = GqlHelper.get50N00((String)CypherExecutionException.class.getSimpleName(), (String)msg);
        return new CypherExecutionException(gql, msg, cause);
    }

    public static CypherExecutionException createEntity(String entity, String name) {
        String msg = String.format("Failed to create the specified %s '%s'", entity, name);
        ErrorGqlStatusObject gql = GqlHelper.get50N00((String)CypherExecutionException.class.getSimpleName(), (String)msg);
        return new CypherExecutionException(gql, msg);
    }

    public static CypherExecutionException createEntityCause(String entity, String name, Throwable cause) {
        String msg = String.format("Failed to create the specified %s '%s'", entity, name);
        ErrorGqlStatusObject gql = GqlHelper.get50N00((String)CypherExecutionException.class.getSimpleName(), (String)msg);
        return new CypherExecutionException(gql, msg, cause);
    }

    public static CypherExecutionException deleteEntityCause(String entity, String name, Throwable cause) {
        String msg = String.format("Failed to delete the specified %s '%s'", entity, name);
        ErrorGqlStatusObject gql = GqlHelper.get50N00((String)CypherExecutionException.class.getSimpleName(), (String)msg);
        return new CypherExecutionException(gql, msg, cause);
    }

    public static CypherExecutionException alterEntityCause(String entity, String name, Throwable cause) {
        String msg = String.format("Failed to alter the specified %s '%s'", entity, name);
        ErrorGqlStatusObject gql = GqlHelper.get50N00((String)CypherExecutionException.class.getSimpleName(), (String)msg);
        return new CypherExecutionException(gql, msg, cause);
    }

    public static CypherExecutionException renameEntityCauseNoTargetName(String entity, String oldName, Throwable cause) {
        String msg = String.format("Failed to rename the specified %s '%s'.", entity, oldName);
        ErrorGqlStatusObject gql = GqlHelper.get50N00((String)CypherExecutionException.class.getSimpleName(), (String)msg);
        return new CypherExecutionException(gql, msg, cause);
    }

    public static CypherExecutionException renameEntityCause(String entity, String oldName, String newName, Throwable cause) {
        String msg = String.format("Failed to rename the specified %s '%s' to '%s'.", entity, oldName, newName);
        ErrorGqlStatusObject gql = GqlHelper.get50N00((String)CypherExecutionException.class.getSimpleName(), (String)msg);
        return new CypherExecutionException(gql, msg, cause);
    }

    public static CypherExecutionException createRoleCopyCause(String role, Throwable cause) {
        String msg = String.format("Failed to create a role as copy of '%s'", role);
        ErrorGqlStatusObject gql = GqlHelper.get50N00((String)CypherExecutionException.class.getSimpleName(), (String)msg);
        return new CypherExecutionException(gql, msg, cause);
    }

    public static CypherExecutionException dbStart(String dbName, Throwable cause) {
        String msg = String.format("Failed to start the specified database '%s'.", dbName);
        ErrorGqlStatusObject gql = GqlHelper.get50N00((String)CypherExecutionException.class.getSimpleName(), (String)msg);
        return new CypherExecutionException(gql, msg, cause);
    }

    public static CypherExecutionException dbStop(String dbName, Throwable cause) {
        String msg = String.format("Failed to stop the specified database '%s'.", dbName);
        ErrorGqlStatusObject gql = GqlHelper.get50N00((String)CypherExecutionException.class.getSimpleName(), (String)msg);
        return new CypherExecutionException(gql, msg, cause);
    }

    public static CypherExecutionException enableServer(String server, Throwable cause) {
        String msg = String.format("Failed to enable the specified server '%s'.", server);
        ErrorGqlStatusObject gql = GqlHelper.get50N00((String)CypherExecutionException.class.getSimpleName(), (String)msg);
        return new CypherExecutionException(gql, msg, cause);
    }

    public static CypherExecutionException reallocateDbs(Throwable cause) {
        String msg = String.format("Failed to reallocate databases: %s", cause.getMessage());
        ErrorGqlStatusObject gql = GqlHelper.get50N00((String)CypherExecutionException.class.getSimpleName(), (String)msg);
        return new CypherExecutionException(gql, msg, cause);
    }

    public static CypherExecutionException deallocateServers(String names, Throwable cause) {
        String msg = String.format("Failed to deallocate the specified server(s) '%s'.", names);
        ErrorGqlStatusObject gql = GqlHelper.get50N00((String)CypherExecutionException.class.getSimpleName(), (String)msg);
        return new CypherExecutionException(gql, msg, cause);
    }

    public static CypherExecutionException grantRole(String role, String userName, Throwable cause) {
        String msg = String.format("Failed to grant role '%s' to user '%s'.", role, userName);
        ErrorGqlStatusObject gql = GqlHelper.get50N00((String)CypherExecutionException.class.getSimpleName(), (String)msg);
        return new CypherExecutionException(gql, msg, cause);
    }

    public static CypherExecutionException revokeRole(String role, String userName, Throwable cause) {
        String msg = String.format("Failed to revoke role '%s' from user '%s'.", role, userName);
        ErrorGqlStatusObject gql = GqlHelper.get50N00((String)CypherExecutionException.class.getSimpleName(), (String)msg);
        return new CypherExecutionException(gql, msg, cause);
    }

    public static CypherExecutionException grantOrDenyExecutionPlan(String msg, Throwable cause) {
        ErrorGqlStatusObject gql = GqlHelper.get50N00((String)CypherExecutionException.class.getSimpleName(), (String)msg);
        return new CypherExecutionException(gql, msg, cause);
    }

    public static CypherExecutionException makeOrRevoke(String msg, Throwable cause) {
        ErrorGqlStatusObject gql = GqlHelper.get50N00((String)CypherExecutionException.class.getSimpleName(), (String)msg);
        return new CypherExecutionException(gql, msg, cause);
    }

    public static CypherExecutionException alterOwnPassword(String userName, Throwable cause) {
        String msg = String.format("User '%s' failed to alter their own password.", userName);
        ErrorGqlStatusObject gql = GqlHelper.get50N00((String)CypherExecutionException.class.getSimpleName(), (String)msg);
        return new CypherExecutionException(gql, msg, cause);
    }

    public static CypherExecutionException entityFromOtherDb(String elementId, String currentDb, String expectedDb) {
        String legacyMsg = "Can not use an entity from another database. Entity element id: " + elementId + ", entity database: " + currentDb + ", expected database: " + expectedDb + ".";
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22000).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42N04).withParam(GqlParams.StringParam.db1, expectedDb).withParam(GqlParams.StringParam.db2, currentDb).withParam(GqlParams.StringParam.db3, expectedDb).build()).build();
        return new CypherExecutionException(gql, legacyMsg);
    }

    public Status status() {
        Throwable cause = this.getCause();
        if (cause instanceof Status.HasStatus) {
            return ((Status.HasStatus)cause).status();
        }
        return Status.Statement.ExecutionFailed;
    }
}

